"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ackWatch = ackWatch;
exports.ackWatchRoute = ackWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function ackWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          watchId,
          actionId
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      let path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(watchId)}/_ack`;
      if (actionId) {
        path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(watchId)}/_ack/${actionId}`;
      }
      const {
        body: resp
      } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'put',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`ackWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function ackWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.put({
    path: `${_constants.ROUTE_PATH.WATCH}/{watchId}/_ack/{actionId?}`,
    validate: {
      params: _configSchema.schema.object({
        watchId: _configSchema.schema.string(),
        actionId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, ackWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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