"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createWatch = createWatch;
exports.createWatchRoute = createWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function createWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        body,
        params: {
          id
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(id)}`;
      const {
        body: resp
      } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'put',
        path,
        body
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`createWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function createWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.put({
    path: `${_constants.ROUTE_PATH.WATCH}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.object({
        actions: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        })),
        checks: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        })),
        trigger: _configSchema.schema.object({}, {
          unknowns: 'allow'
        }),
        _meta: _configSchema.schema.object({}, {
          unknowns: 'allow'
        }),
        // ES plugin meta
        _ui: _configSchema.schema.object({}, {
          unknowns: 'allow'
        }),
        // UI meta
        active: _configSchema.schema.boolean(),
        log_runtime_data: _configSchema.schema.maybe(_configSchema.schema.boolean())
      }, {
        unknowns: 'allow'
      })
    }
  }, createWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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