"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteWatch = deleteWatch;
exports.deleteWatchRoute = deleteWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function deleteWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          id
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(id)}`;
      const {
        body: resp
      } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'delete',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`deleteWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function deleteWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.delete({
    path: `${_constants.ROUTE_PATH.WATCH}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, deleteWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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