"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeWatch = executeWatch;
exports.executeWatchRoute = executeWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function executeWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        body: {
          watch,
          simulate = false,
          skipActions = true,
          showAllRuntimeAttributes = true
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/_execute`;
      const {
        body: resp
      } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'post',
        path,
        body: {
          watch,
          simulate,
          skip_actions: skipActions,
          show_all_runtime_attributes: showAllRuntimeAttributes
        }
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`executeWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function executeWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.ROUTE_PATH.WATCH}/_execute`,
    validate: {
      body: _configSchema.schema.object({
        watch: _configSchema.schema.object({
          checks: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
            unknowns: 'allow'
          })),
          actions: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
            unknowns: 'allow'
          })),
          trigger: _configSchema.schema.object({}, {
            unknowns: 'allow'
          }),
          _meta: _configSchema.schema.object({}, {
            unknowns: 'allow'
          })
        }, {
          unknowns: 'allow'
        }),
        simulate: _configSchema.schema.boolean({
          defaultValue: false
        }),
        skipActions: _configSchema.schema.boolean({
          defaultValue: true
        }),
        showAllRuntimeAttributes: _configSchema.schema.boolean({
          defaultValue: true
        })
      })
    }
  }, executeWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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