"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeGraphWatch = executeGraphWatch;
exports.executeGraphWatchRoute = executeGraphWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function executeGraphWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        body: {
          request: {
            indices: index,
            body
          }
        }
      } = request;
      const {
        body: resp
      } = await clusterClient.asScoped(request).asCurrentUser.search({
        body,
        index
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`executeGraphWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function executeGraphWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.ROUTE_PATH.WATCH}/_execute_graph`,
    validate: {
      body: _configSchema.schema.object({
        request: _configSchema.schema.object({
          indices: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
            defaultValue: []
          }),
          body: _configSchema.schema.object({}, {
            unknowns: 'allow',
            defaultValue: {}
          })
        }, {
          defaultValue: {
            indices: [],
            body: {}
          }
        })
      })
    }
  }, executeGraphWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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