"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWatch = getWatch;
exports.getWatchRoute = getWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _helpers = require("../../lib/helpers");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function getWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          id
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(id)}`;
      const {
        body: {
          _source,
          _id
        }
      } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'get',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp: {
            ..._source,
            _id: (0, _helpers.getId)(_id)
          }
        }
      });
    } catch (err) {
      if (err.statusCode !== 404) {
        logger.error(`getWatch: ${err.stack}`);
      }
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function getWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.get({
    path: `${_constants.ROUTE_PATH.WATCH}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, getWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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