"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateOfWatch = stateOfWatch;
exports.stateOfWatchRoute = stateOfWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function stateOfWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          id
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(id)}/_state`;
      const {
        body: resp
      } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'get',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`stateOfWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function stateOfWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.get({
    path: `${_constants.ROUTE_PATH.WATCH}/{id}/_state`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, stateOfWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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