"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWatches = getWatches;
exports.getWatchesRoute = getWatchesRoute;
var _configSchema = require("@kbn/config-schema");
var _lib = require("../../lib");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function getWatches({
  clusterClient,
  fetchAllFromScroll,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        },
        body: {
          query,
          scroll
        }
      } = request;
      const body = {};
      if (query && !!Object.keys(query).length) {
        body.query = query;
      }
      const {
        body: firstScrollResponse
      } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'post',
        path: `/_signals/watch/${encodeURIComponent(sgtenant)}/_search?scroll=${scroll}`,
        body
      });
      const hits = await fetchAllFromScroll({
        clusterClient,
        scroll,
        request,
        response: firstScrollResponse
      });
      return response.ok({
        body: {
          ok: true,
          resp: hits.map(h => ({
            ...h._source,
            _id: (0, _lib.getId)(h._id)
          }))
        }
      });
    } catch (err) {
      logger.error(`getWatches: ${err.stack}`);
      return response.customError((0, _lib.serverError)(err));
    }
  };
}
function getWatchesRoute({
  router,
  clusterClient,
  fetchAllFromScroll,
  logger
}) {
  router.post({
    path: _constants.ROUTE_PATH.WATCHES,
    validate: {
      body: _configSchema.schema.object({
        scroll: _configSchema.schema.string({
          defaultValue: _constants.ES_SCROLL_SETTINGS.KEEPALIVE
        }),
        query: _configSchema.schema.object({}, {
          unknowns: 'allow'
        })
      })
    }
  }, getWatches({
    clusterClient,
    fetchAllFromScroll,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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