"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CONFIG = void 0;
var _package = require("../package.json");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const DEFAULT_CONFIG = exports.DEFAULT_CONFIG = {
  searchguard: {
    enabled: true,
    sg_frontend_config_id: "default",
    frontend_base_url: null,
    allow_client_certificates: false,
    readonly_mode: {
      enabled: true,
      roles: []
    },
    xff: {
      enabled: true
    },
    cookie: {
      secure: false,
      password: 'searchguard_cookie_default_password',
      name: 'searchguard_authentication',
      ttl: null,
      isSameSite: 'Lax'
    },
    auth: {
      // @todo This is still being used in the FE, does it really work?
      type: 'default',
      anonymous_auth_enabled: false,
      unauthenticated_routes: ['/api/status'],
      debug: false,
      jwt_param: {
        enabled: false,
        url_param: 'authorization'
      }
    },
    basicauth: {
      forbidden_usernames: [],
      allowed_usernames: null
    },
    multitenancy: {
      enabled: false,
      show_roles: false,
      enable_filter: false,
      debug: false,
      tenants: {
        enable_private: true,
        enable_global: true,
        preferred: undefined
      },
      saved_objects_migration: {
        batch_size: 100,
        max_batch_size: "100mb",
        scroll_duration: '15m',
        poll_interval: 1500,
        skip: false,
        enableV2: true
      }
    },
    configuration: {
      enabled: true,
      action_groups_page: {
        enabled: true
      },
      create_action_groups_page: {
        enabled: true
      },
      internal_users_page: {
        enabled: true
      },
      create_internal_users_page: {
        enabled: true
      },
      roles_page: {
        enabled: true
      },
      create_roles_page: {
        enabled: true
      },
      role_mappings_page: {
        enabled: true
      },
      create_role_mappings_page: {
        enabled: true
      },
      tenants_page: {
        enabled: true
      },
      create_tenants_page: {
        enabled: true
      },
      system_status_page: {
        enabled: true
      },
      license_page: {
        enabled: true
      },
      cache_page: {
        enabled: true
      }
    },
    accountinfo: {
      enabled: true
    },
    sgVersion: _package.version
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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