"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.ConfigSchema = void 0;
exports.plugin = plugin;
var _configSchema = require("@kbn/config-schema");
var _serverPlugin = require("./serverPlugin");
var _package = require("../package.json");
var _default_config = require("./default_config");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const {
  searchguard: {
    cookie: cookieDefaults,
    auth: authDefaults,
    basicauth: basicauthDefaults,
    multitenancy: multitenancyDefaults,
    ...searchguardDefaults
  } = {}
} = _default_config.DEFAULT_CONFIG;

// @todo We need to go through all of these and double check the default values, nullable, allow empty string etc.
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: searchguardDefaults.enabled
  }),
  sg_frontend_config_id: _configSchema.schema.string({
    defaultValue: searchguardDefaults.sg_frontend_config_id
  }),
  frontend_base_url: _configSchema.schema.string({
    defaultValue: searchguardDefaults.frontend_base_url
  }),
  allow_client_certificates: _configSchema.schema.boolean({
    defaultValue: searchguardDefaults.allow_client_certificates
  }),
  readonly_mode: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: searchguardDefaults.readonly_mode.enabled
    }),
    roles: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: searchguardDefaults.readonly_mode.roles
    })
  }),
  xff: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: searchguardDefaults.xff.enabled
    })
  }),
  cookie: _configSchema.schema.object({
    secure: _configSchema.schema.boolean({
      defaultValue: cookieDefaults.secure
    }),
    name: _configSchema.schema.string({
      defaultValue: cookieDefaults.name
    }),
    password: _configSchema.schema.string({
      minLength: 32,
      defaultValue: cookieDefaults.password
    }),
    ttl: _configSchema.schema.nullable(_configSchema.schema.number({
      defaultValue: cookieDefaults.ttl
    })),
    domain: _configSchema.schema.maybe(_configSchema.schema.string()),
    isSameSite: _configSchema.schema.oneOf([
    // @todo Check the changes in Chrome 80 here - more values needed? Compare with hapi-auth-cookie
    _configSchema.schema.literal('None'), _configSchema.schema.literal('Strict'), _configSchema.schema.literal('Lax')], {
      defaultValue: cookieDefaults.isSameSite
    })
  }),
  /**
   * General auth
   */
  auth: _configSchema.schema.object({
    type: _configSchema.schema.oneOf([_configSchema.schema.literal('default'), _configSchema.schema.literal('proxy'), _configSchema.schema.literal('kerberos')], {
      defaultValue: authDefaults.type
    }),
    anonymous_auth_enabled: _configSchema.schema.boolean({
      defaultValue: authDefaults.anonymous_auth_enabled
    }),
    unauthenticated_routes: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: authDefaults.unauthenticated_routes
    }),
    /*
      Caution: Enabling this may cause sensitive authentication information (e.g. credentials) to be logged
    */
    debug: _configSchema.schema.boolean({
      defaultValue: authDefaults.debug
    }),
    jwt_param: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: authDefaults.jwt_param.enabled
      }),
      url_param: _configSchema.schema.string({
        defaultValue: authDefaults.jwt_param.url_param
      })
    })
  }),
  /**
   * Basic auth
   */
  basicauth: _configSchema.schema.object({
    forbidden_usernames: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: basicauthDefaults.forbidden_usernames
    }),
    allowed_usernames: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }),
  /**
   * Multitenancy
   */
  multitenancy: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: multitenancyDefaults.enabled
    }),
    show_roles: _configSchema.schema.boolean({
      defaultValue: multitenancyDefaults.show_roles
    }),
    enable_filter: _configSchema.schema.boolean({
      defaultValue: multitenancyDefaults.enable_filter
    }),
    debug: _configSchema.schema.boolean({
      defaultValue: multitenancyDefaults.debug
    }),
    tenants: _configSchema.schema.object({
      enable_private: _configSchema.schema.boolean({
        defaultValue: multitenancyDefaults.tenants.enable_private
      }),
      enable_global: _configSchema.schema.boolean({
        defaultValue: multitenancyDefaults.tenants.enable_global
      }),
      preferred: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
    }),
    saved_objects_migration: _configSchema.schema.object({
      batch_size: _configSchema.schema.number({
        defaultValue: multitenancyDefaults.saved_objects_migration.batch_size
      }),
      scroll_duration: _configSchema.schema.string({
        defaultValue: multitenancyDefaults.saved_objects_migration.scroll_duration
      }),
      poll_interval: _configSchema.schema.number({
        defaultValue: multitenancyDefaults.saved_objects_migration.poll_interval
      }),
      skip: _configSchema.schema.boolean({
        defaultValue: multitenancyDefaults.saved_objects_migration.skip
      }),
      enableV2: _configSchema.schema.boolean({
        defaultValue: multitenancyDefaults.saved_objects_migration.enableV2
      }),
      max_batch_size: _configSchema.schema.string({
        defaultValue: multitenancyDefaults.saved_objects_migration.max_batch_size
      })
    })
  }),
  configuration: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: searchguardDefaults.configuration.enabled
    }),
    action_groups_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.action_groups_page.enabled
      })
    }),
    create_action_groups_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_action_groups_page.enabled
      })
    }),
    internal_users_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.internal_users_page.enabled
      })
    }),
    create_internal_users_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_internal_users_page.enabled
      })
    }),
    roles_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.roles_page.enabled
      })
    }),
    create_roles_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_roles_page.enabled
      })
    }),
    role_mappings_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.role_mappings_page.enabled
      })
    }),
    create_role_mappings_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_role_mappings_page.enabled
      })
    }),
    tenants_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.tenants_page.enabled
      })
    }),
    create_tenants_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_tenants_page.enabled
      })
    }),
    system_status_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.system_status_page.enabled
      })
    }),
    license_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.license_page.enabled
      })
    }),
    cache_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.cache_page.enabled
      })
    })
  }),
  accountinfo: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: searchguardDefaults.accountinfo.enabled
    })
  }),
  sgVersion: _configSchema.schema.string({
    defaultValue: _package.version
  })
});
const config = exports.config = {
  exposeToBrowser: {
    auth: true,
    multitenancy: true,
    basicauth: true,
    configuration: true,
    accountinfo: true,
    readonly_mode: true,
    sgVersion: true
  },
  schema: ConfigSchema,
  deprecations: ({
    unusedFromRoot
  }) => {
    return [];
  }
};
function plugin(initializerContext) {
  return new _serverPlugin.ServerPlugin(initializerContext);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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