"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerPlugin = void 0;
var _operators = require("rxjs/operators");
var _applications = require("./applications");
var _config_service = require("../common/config_service");
var _searchguard = _interopRequireDefault(require("./applications/searchguard/backend/searchguard"));
var _searchguard_configuration_backend = _interopRequireDefault(require("./applications/searchguard/configuration/backend/searchguard_configuration_backend"));
var _multitenancy = require("./applications/multitenancy");
/*
 *    Copyright 2021 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

async function getConfigService({
  logger,
  initContext,
  clusterClient
}) {
  try {
    const [kibanaConfig, sgConfig] = await Promise.all([initContext.config.legacy.globalConfig$.pipe((0, _operators.first)()).toPromise(), initContext.config.create().pipe((0, _operators.first)()).toPromise()]);
    return new _config_service.ConfigService({
      ...kibanaConfig,
      elasticsearch: clusterClient.config,
      searchguard: sgConfig
    });
  } catch (error) {
    logger.error(`Failed to fetch the Kibana config, ${error}`);
    throw error;
  }
}
class ServerPlugin {
  constructor(initializerContext) {
    this.logger = initializerContext.logger.get();
    this.initContext = initializerContext;
    this.signalsApp = new _applications.Signals(this.initContext);
    this.searchGuardApp = new _applications.SearchGuard(this.initContext);
    this.multiTenancyApp = new _applications.Multitenancy(this.initContext);
    this.authTokensApp = new _applications.AuthTokens(this.initContext);
  }

  /*
  ATTENTION! Kibana imposes restrictions to the plugin lifecycle methods:
  1. A method must not return promise.
  2. A method execution time limit is 10 seconds.
  */
  setup(core, pluginDependencies) {
    process.on('unhandledRejection', error => {
      console.error(error); // This prints error with stack included (as for normal errors)
    });
    this.kibanaRouter = core.http.createRouter();
    (async () => {
      const [{
        elasticsearch,
        savedObjects
      }] = await core.getStartServices();
      const configService = await getConfigService({
        logger: this.logger,
        initContext: this.initContext,
        clusterClient: elasticsearch.client
      });
      const searchGuardBackend = new _searchguard.default({
        elasticsearch,
        configService,
        core
      });
      const searchGuardConfigurationBackend = new _searchguard_configuration_backend.default({
        elasticsearch
      });
      const tenantService = new _multitenancy.TenantService({
        clusterClient: elasticsearch.client,
        logger: this.logger,
        configService,
        savedObjects,
        coreContext: this.initContext
      });
      const spacesService = new _multitenancy.SpacesService({
        kibanaVersion: this.initContext.env.packageInfo.version,
        tenantService
      });
      const {
        authManager,
        sessionStorageFactory,
        kerberos
      } = await this.searchGuardApp.setup({
        core,
        pluginDependencies,
        configService,
        kibanaRouter: this.kibanaRouter,
        searchGuardBackend,
        searchGuardConfigurationBackend,
        spacesService,
        elasticsearch
      });

      // Helper for the routes
      core.http.registerRouteHandlerContext('searchGuard', () => {
        return {
          sessionStorageFactory,
          authManager
        };
      });
      const isMtEnabled = configService.get('searchguard.multitenancy.enabled');
      if (isMtEnabled) {
        this.multiTenancyApp.setup({
          kibanaRouter: this.kibanaRouter,
          authManager,
          kerberos,
          kibanaCore: core,
          sessionStorageFactory,
          pluginDependencies,
          searchGuardBackend,
          configService,
          spacesService,
          tenantService,
          savedObjects,
          elasticsearch
        });
      }
    })();
  }
  start(core) {
    (async () => {
      const configService = await getConfigService({
        logger: this.logger,
        initContext: this.initContext,
        clusterClient: core.elasticsearch.client
      });
      const searchGuardBackend = new _searchguard.default({
        elasticsearch: core.elasticsearch,
        configService,
        core
      });
      this.signalsApp.start({
        core,
        kibanaRouter: this.kibanaRouter,
        searchguardBackendService: searchGuardBackend
      });
      this.authTokensApp.start({
        core,
        kibanaRouter: this.kibanaRouter
      });
      const isMtEnabled = configService.get('searchguard.multitenancy.enabled');
      if (isMtEnabled) {
        // ATTENTION! We want to make sure the multitenancy app migrates saved objects
        // in the tenants indices before doing any operation on indices
        this.multiTenancyApp.start({
          core,
          searchGuardBackend,
          configService
        });
      }
    })();
  }
}
exports.ServerPlugin = ServerPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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