"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAllFromScroll = void 0;
var _lodash = require("lodash");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const fetchAllFromScroll = async ({
  clusterClient,
  scroll,
  request,
  response
}) => {
  let hits = (0, _lodash.get)(response, 'hits.hits', []);
  let scrollId = (0, _lodash.get)(response, '_scroll_id');
  const allHits = [...hits];
  if (hits.length) {
    while (true) {
      const {
        body: promisedResp
      } = await clusterClient.asScoped(request).asCurrentUser.scroll({
        body: {
          scroll,
          scroll_id: scrollId
        }
      });
      hits = (0, _lodash.get)(promisedResp, 'hits.hits', []);
      if (!hits.length) {
        return allHits;
      }
      scrollId = (0, _lodash.get)(promisedResp, '_scroll_id');
      allHits.push(...hits);
    }
  }
  return allHits;
};
exports.fetchAllFromScroll = fetchAllFromScroll;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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