"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCookieExpiryTimeMS = getCookieExpiryTimeMS;
exports.getCookieExpiryTimeS = getCookieExpiryTimeS;
exports.setupAuthInstanceMock = setupAuthInstanceMock;
exports.setupClusterClientMock = setupClusterClientMock;
exports.setupConfigMock = setupConfigMock;
exports.setupContextMock = setupContextMock;
exports.setupDebugLogMock = setupDebugLogMock;
exports.setupFetchAllFromScrollMock = setupFetchAllFromScrollMock;
exports.setupHttpResponseMock = setupHttpResponseMock;
exports.setupHttpRouterMock = setupHttpRouterMock;
exports.setupHttpToolkitMock = setupHttpToolkitMock;
exports.setupKibanaCoreMock = setupKibanaCoreMock;
exports.setupLoggerMock = setupLoggerMock;
exports.setupPluginDependenciesMock = setupPluginDependenciesMock;
exports.setupSavedObjectsMock = setupSavedObjectsMock;
exports.setupSearchGuardBackendMock = setupSearchGuardBackendMock;
exports.setupSessionStorageFactoryMock = setupSessionStorageFactoryMock;
exports.setupTypeRegistryMock = setupTypeRegistryMock;
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* global jest */

function getCookieExpiryTimeMS(expireInDaysFromNow = 0) {
  const today = new Date();
  const expiryTime = new Date(today);
  expiryTime.setDate(expiryTime.getDate() + expireInDaysFromNow);
  return expiryTime.getTime();
}
function getCookieExpiryTimeS(...props) {
  return Math.floor(getCookieExpiryTimeMS(...props) / 1000);
}
function setupHttpRouterMock({
  ensureRawRequest = () => jest.fn()
} = {}) {
  return {
    ensureRawRequest
  };
}
function setupSearchGuardBackendMock({
  authinfo = jest.fn(),
  validateTenant = jest.fn(),
  hasPermissions = jest.fn(),
  getTenantByPreference = jest.fn(),
  authenticateWithHeader = jest.fn(),
  authenticateWithHeaders = jest.fn(),
  getTenantInfoWithInternalUser = jest.fn(),
  getOIDCWellKnown = jest.fn(),
  getOIDCToken = jest.fn()
} = {}) {
  return {
    authinfo,
    validateTenant,
    hasPermissions,
    getTenantByPreference,
    authenticateWithHeader,
    authenticateWithHeaders,
    getTenantInfoWithInternalUser,
    getOIDCWellKnown,
    getOIDCToken
  };
}
function setupKibanaCoreMock({
  basePath = '/abc',
  registerOnPreResponse = jest.fn(),
  getServerInfo = jest.fn()
} = {}) {
  return {
    http: {
      getServerInfo,
      basePath: {
        get: jest.fn(() => basePath)
      },
      registerOnPreResponse
    }
  };
}
function setupConfigMock({
  get = jest.fn()
} = {}) {
  return {
    get
  };
}
function setupLoggerMock({
  info = jest.fn(),
  error = jest.fn(),
  warn = jest.fn(),
  debug = jest.fn()
} = {}) {
  return {
    error,
    info,
    warn,
    debug
  };
}
function setupSessionStorageFactoryMock({
  asScoped = jest.fn()
} = {}) {
  return {
    asScoped
  };
}
function setupPluginDependenciesMock() {
  return jest.fn();
}
function setupTypeRegistryMock({
  getAllTypes = jest.fn().mockReturnValue([])
} = {}) {
  return {
    getAllTypes
  };
}
function setupSavedObjectsMock({
  getScopedClient = jest.fn(),
  createInternalRepository = jest.fn(),
  createScopedRepository = jest.fn(),
  createSerializer = jest.fn(),
  createExporter = jest.fn(),
  createImporter = jest.fn(),
  getTypeRegistry = setupTypeRegistryMock
} = {}) {
  return {
    getScopedClient,
    createInternalRepository,
    createScopedRepository,
    createSerializer,
    createExporter,
    createImporter,
    getTypeRegistry
  };
}
function setupHttpResponseMock({
  ok = jest.fn(),
  redirected = jest.fn(),
  unauthorized = jest.fn(),
  notFound = jest.fn(),
  internalError = jest.fn(),
  renderAnonymousCoreApp = jest.fn(),
  customError = jest.fn(),
  badRequest = jest.fn()
} = {}) {
  return {
    ok,
    redirected,
    unauthorized,
    notFound,
    internalError,
    renderAnonymousCoreApp,
    customError,
    badRequest
  };
}
function setupHttpToolkitMock({
  next = jest.fn(),
  notHandled = jest.fn(),
  authenticated = jest.fn()
} = {}) {
  return {
    next,
    notHandled,
    authenticated
  };
}
function setupAuthInstanceMock({
  getAllAuthHeaders = jest.fn(),
  handleAuthenticateWithHeaders = jest.fn(),
  handleAuthenticate = jest.fn(),
  clear = jest.fn()
} = {}) {
  return {
    getAllAuthHeaders,
    handleAuthenticateWithHeaders,
    handleAuthenticate,
    clear
  };
}
function setupContextMock() {
  return jest.fn();
}
function setupDebugLogMock() {
  return jest.fn();
}
function setupClusterClientMock({
  asCurrentUserTransportRequest = jest.fn(),
  asCurrentUserScroll = jest.fn(),
  asCurrentUserSearch = jest.fn(),
  asCurrentUserDelete = jest.fn(),
  asCurrentUserCatAliases = jest.fn(),
  asCurrentUserCatIndices = jest.fn(),
  asCurrentUserIndicesGetMapping = jest.fn()
} = {}) {
  return {
    asScoped: jest.fn(() => {
      return {
        asCurrentUser: {
          transport: {
            request: asCurrentUserTransportRequest
          },
          scroll: asCurrentUserScroll,
          search: asCurrentUserSearch,
          delete: asCurrentUserDelete,
          cat: {
            aliases: asCurrentUserCatAliases,
            indices: asCurrentUserCatIndices
          },
          indices: {
            getMapping: asCurrentUserIndicesGetMapping
          }
        }
      };
    })
  };
}
function setupFetchAllFromScrollMock(mockFn = jest.fn()) {
  return mockFn;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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