"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapForCustomError = wrapForCustomError;
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function wrapForCustomError(error) {
  if (!(error instanceof Error)) {
    throw new Error('The provided argument must be instance of Error.');
  }
  const customError = {
    statusCode: error.statusCode || 500,
    body: {
      message: error.message || 'Internal Server Error'
    }
  };
  if (error.body) {
    customError.body.attributes = {
      body: error.body
    };
  }
  return customError;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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