"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEsRoutes = registerEsRoutes;
var _search = require("./search");
var _get_indices = require("./get_indices");
var _get_aliases = require("./get_aliases");
var _get_mappings = require("./get_mappings");
/* eslint-disable @kbn/eslint/require-license-header */

function registerEsRoutes({
  router,
  clusterClient,
  logger
}) {
  (0, _search.searchEsRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _get_indices.getIndicesRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _get_aliases.getAliasesRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _get_mappings.getMappingsRoute)({
    router,
    clusterClient,
    logger
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc2VhcmNoIiwicmVxdWlyZSIsIl9nZXRfaW5kaWNlcyIsIl9nZXRfYWxpYXNlcyIsIl9nZXRfbWFwcGluZ3MiLCJyZWdpc3RlckVzUm91dGVzIiwicm91dGVyIiwiY2x1c3RlckNsaWVudCIsImxvZ2dlciIsInNlYXJjaEVzUm91dGUiLCJnZXRJbmRpY2VzUm91dGUiLCJnZXRBbGlhc2VzUm91dGUiLCJnZXRNYXBwaW5nc1JvdXRlIl0sInNvdXJjZXMiOlsiaW5kZXguanMiXSwic291cmNlc0NvbnRlbnQiOlsiLyogZXNsaW50LWRpc2FibGUgQGtibi9lc2xpbnQvcmVxdWlyZS1saWNlbnNlLWhlYWRlciAqL1xuaW1wb3J0IHsgc2VhcmNoRXNSb3V0ZSB9IGZyb20gJy4vc2VhcmNoJztcbmltcG9ydCB7IGdldEluZGljZXNSb3V0ZSB9IGZyb20gJy4vZ2V0X2luZGljZXMnO1xuaW1wb3J0IHsgZ2V0QWxpYXNlc1JvdXRlIH0gZnJvbSAnLi9nZXRfYWxpYXNlcyc7XG5pbXBvcnQgeyBnZXRNYXBwaW5nc1JvdXRlIH0gZnJvbSAnLi9nZXRfbWFwcGluZ3MnO1xuXG5leHBvcnQgZnVuY3Rpb24gcmVnaXN0ZXJFc1JvdXRlcyh7IHJvdXRlciwgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pIHtcbiAgc2VhcmNoRXNSb3V0ZSh7IHJvdXRlciwgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pO1xuICBnZXRJbmRpY2VzUm91dGUoeyByb3V0ZXIsIGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KTtcbiAgZ2V0QWxpYXNlc1JvdXRlKHsgcm91dGVyLCBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSk7XG4gIGdldE1hcHBpbmdzUm91dGUoeyByb3V0ZXIsIGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0EsSUFBQUEsT0FBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsWUFBQSxHQUFBRCxPQUFBO0FBQ0EsSUFBQUUsWUFBQSxHQUFBRixPQUFBO0FBQ0EsSUFBQUcsYUFBQSxHQUFBSCxPQUFBO0FBSkE7O0FBTU8sU0FBU0ksZ0JBQWdCQSxDQUFDO0VBQUVDLE1BQU07RUFBRUMsYUFBYTtFQUFFQztBQUFPLENBQUMsRUFBRTtFQUNsRSxJQUFBQyxxQkFBYSxFQUFDO0lBQUVILE1BQU07SUFBRUMsYUFBYTtJQUFFQztFQUFPLENBQUMsQ0FBQztFQUNoRCxJQUFBRSw0QkFBZSxFQUFDO0lBQUVKLE1BQU07SUFBRUMsYUFBYTtJQUFFQztFQUFPLENBQUMsQ0FBQztFQUNsRCxJQUFBRyw0QkFBZSxFQUFDO0lBQUVMLE1BQU07SUFBRUMsYUFBYTtJQUFFQztFQUFPLENBQUMsQ0FBQztFQUNsRCxJQUFBSSw4QkFBZ0IsRUFBQztJQUFFTixNQUFNO0lBQUVDLGFBQWE7SUFBRUM7RUFBTyxDQUFDLENBQUM7QUFDckQiLCJpZ25vcmVMaXN0IjpbXX0=