"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateOfWatch = stateOfWatch;
exports.stateOfWatchRoute = stateOfWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function stateOfWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          id
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(id)}/_state`;
      const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'get',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`stateOfWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function stateOfWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.get({
    path: `${_constants.ROUTE_PATH.WATCH}/{id}/_state`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, stateOfWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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