"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasPermissions = hasPermissions;
exports.hasPermissionsRoute = hasPermissionsRoute;
var _lib = require("../../lib");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function hasPermissions({
  logger,
  searchguardBackendService
}) {
  return async function (context, request, response) {
    try {
      const {
        permissions = {}
      } = await searchguardBackendService.hasPermissions(request.headers, _constants.PERMISSIONS_FOR_ACCESS);
      return response.ok({
        body: {
          ok: true,
          resp: Object.values(permissions).includes(true)
        }
      });
    } catch (err) {
      logger.error(`hasPermissions: ${err.stack}`);
      return response.customError((0, _lib.serverError)(err));
    }
  };
}
function hasPermissionsRoute({
  router,
  logger,
  searchguardBackendService
}) {
  router.post({
    path: _constants.ROUTE_PATH.SEARCHGUARD.SIGNALS_HAS_PERMISSIONS,
    options: {
      authRequired: 'optional'
    },
    validate: false
  }, hasPermissions({
    logger,
    searchguardBackendService
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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