"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndices = void 0;
exports.getIndicesRoute = getIndicesRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getIndices = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      index
    } = request.body;
    const options = {
      ignore_unavailable: true,
      index,
      body: {
        size: 0,
        // no hits
        aggs: {
          indices: {
            terms: {
              field: '_index',
              size: 800
            }
          }
        }
      }
    };
    const result = await clusterClient.asScoped(request).asCurrentUser.search(options);
    const {
      aggregations: {
        indices: {
          buckets = []
        } = {}
      } = {}
    } = result;
    return response.ok({
      body: {
        ok: true,
        resp: buckets.map(({
          key
        }) => ({
          index: key,
          health: 'green',
          // TODO: find real health instead
          status: 'open' // TODO: find real status instead
        }))
      }
    });
  } catch (err) {
    logger.error(`getIndices: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.getIndices = getIndices;
function getIndicesRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.BASE_URI}/_indices`,
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })
    }
  }, getIndices({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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