"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.summary = summary;
exports.summaryRoute = summaryRoute;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../../common/signals/constants");
var _lib = require("../../lib");
function summary({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        body: {
          query
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;

      /**
       * Filters passed as part of the request body
       *
       * @type {Object}
       */
      let body = {};

      /**
       * Filters passed as url search params
       * Not using URLSearchParams because its toString method encodes + to %2B.
       *
       * @type {Object}
       */
      let searchParams = {
        //sorting: "-severity_details.level_numeric"
      };

      // Validate and split up filtering/sorting parameters
      if (query && typeof query === 'object' && !!Object.keys(query).length) {
        const allowedBodyParams = ['watch_id']; // 'severities'
        const allowedSearchParams = ['sorting', 'size'];
        Object.keys(query).forEach(key => {
          const property = key.toLowerCase();
          if (allowedBodyParams.includes(property)) {
            body[property] = query[property];
          } else if (allowedSearchParams.includes(property)) {
            searchParams[property] = query[property];
          }
        });
      }
      let searchParamsString = '';
      if (Object.keys(searchParams).length > 0) {
        searchParamsString = `?`;
        Object.keys(searchParams).forEach(key => {
          searchParamsString += `${key}=${searchParams[key]}&`;
        });
        searchParamsString = searchParamsString.slice(0, -1);
      }
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/summary${searchParamsString}`;
      const callRequest = {
        method: 'post',
        path,
        body
      };
      const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request(callRequest);
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`stateOfWatch: ${err.stack}`);
      return response.customError((0, _lib.serverError)(err));
    }
  };
}
function summaryRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.ROUTE_PATH.WATCH}/summary`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.object({}, {
          unknowns: 'allow'
        })
      })
    }
  }, summary({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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