"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomCookieWrapper = void 0;
exports.getSessionCookieOptions = getSessionCookieOptions;
function getSessionCookieOptions(configService, basePath) {
  const ttlConfig = configService.get('searchguard.cookie.ttl');
  const ttl = ttlConfig === 0 ? null : ttlConfig;
  const options = {
    ignoreErrors: true,
    password: configService.get('searchguard.cookie.password'),
    isSecure: configService.get('searchguard.cookie.secure'),
    isSameSite: configService.get('searchguard.cookie.isSameSite'),
    clearInvalid: false,
    isHttpOnly: true,
    // Converting 0 to null for backward compatibility.
    // Statehood handles 0 "correctly" and sets the ttl to 0ms as opposed to
    // hapi-auth-cookie, which for 0 sets the ttl to browser session.
    // However, setting ttl to 0 milliseconds would render the cookie invalid immediately
    // https://github.com/hapijs/cookie/blob/v9.0.0/lib/index.js#L110
    ttl,
    // @todo Compare with defaults for hapi auth cookie
    encoding: 'iron',
    path: basePath || '/'
    // @todo hapi-auth-cookie used to handle this for us
    //keepAlive: (ttl !== null && ttl >= 1) ? true : false,
  };
  if (configService.get('searchguard.cookie.domain')) {
    options.domain = configService.get('searchguard.cookie.domain');
  }
  return options;
}
class CustomCookieWrapper {
  constructor(statehoodDefinitions, request, cookieName, options) {
    this.statehoodDefinitions = statehoodDefinitions;
    this.request = request;
    this.cookieName = cookieName;
    this.options = options;
  }
  async get() {
    let cookie = null;
    if (this.request.headers.cookie) {
      // Could probably use this.request.state as well
      const parsed = await this.statehoodDefinitions.parse(this.request.headers.cookie);
      if (parsed.states[this.cookieName]) {
        cookie = parsed.states[this.cookieName];
      }
    }
    return cookie;
  }
  set(value) {
    // Options are needed here because we unfortunately have to use a different
    // instance of Statehood.Definitions when setting the cookie than when reading.
    return this.request.cookieAuth.h.state(this.cookieName, value, this.options);
  }
  clear() {
    return this.request.cookieAuth.h.unstate(this.cookieName);
  }
}
exports.CustomCookieWrapper = CustomCookieWrapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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