"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAlert = void 0;
exports.deleteAlertRoute = deleteAlertRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const deleteAlert = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      id,
      index
    } = request.params;
    const resp = await clusterClient.asScoped(request).asCurrentUser.delete({
      refresh: true,
      index,
      id: id.replace('%2F')
    });
    return response.ok({
      body: {
        ok: resp.result === 'deleted',
        resp
      }
    });
  } catch (err) {
    logger.error(`deleteAlert: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.deleteAlert = deleteAlert;
function deleteAlertRoute({
  router,
  clusterClient,
  logger
}) {
  router.delete({
    path: `${_constants.ROUTE_PATH.ALERT}/{index}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        index: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })
    }
  }, deleteAlert({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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