"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ackWatch = ackWatch;
exports.ackWatchRoute = ackWatchRoute;
exports.unAckWatch = unAckWatch;
exports.unAckWatchRoute = unAckWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function ackWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          watchId,
          actionId
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      let path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(watchId)}/_ack`;
      if (actionId) {
        path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(watchId)}/_ack/${actionId}`;
      }
      const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'put',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`ackWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function unAckWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          watchId,
          actionId
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      let path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(watchId)}/_ack`;
      if (actionId) {
        path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(watchId)}/_ack/${actionId}`;
      }
      const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'delete',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`ackWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function ackWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.put({
    path: `${_constants.ROUTE_PATH.WATCH}/{watchId}/_ack/{actionId?}`,
    validate: {
      params: _configSchema.schema.object({
        watchId: _configSchema.schema.string(),
        actionId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, ackWatch({
    clusterClient,
    logger
  }));
}
function unAckWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.delete({
    path: `${_constants.ROUTE_PATH.WATCH}/{watchId}/_ack/{actionId?}`,
    validate: {
      params: _configSchema.schema.object({
        watchId: _configSchema.schema.string(),
        actionId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, unAckWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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