"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWatches = getWatches;
exports.getWatchesRoute = getWatchesRoute;
var _configSchema = require("@kbn/config-schema");
var _lib = require("../../lib");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function getWatches({
  clusterClient,
  fetchAllFromScroll,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        },
        body: {
          query,
          scroll
        }
      } = request;
      const body = {};
      if (query && !!Object.keys(query).length) {
        body.query = query;
      }
      const firstScrollResponse = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'post',
        path: `/_signals/watch/${encodeURIComponent(sgtenant)}/_search?scroll=${scroll}`,
        body
      });
      const hits = await fetchAllFromScroll({
        clusterClient,
        scroll,
        request,
        response: firstScrollResponse
      });
      return response.ok({
        body: {
          ok: true,
          resp: hits.map(h => ({
            ...h._source,
            _id: (0, _lib.getId)(h._id)
          }))
        }
      });
    } catch (err) {
      logger.error(`getWatches: ${err.stack}`);
      return response.customError((0, _lib.serverError)(err));
    }
  };
}
function getWatchesRoute({
  router,
  clusterClient,
  fetchAllFromScroll,
  logger
}) {
  router.post({
    path: _constants.ROUTE_PATH.WATCHES,
    validate: {
      body: _configSchema.schema.object({
        scroll: _configSchema.schema.string({
          defaultValue: _constants.ES_SCROLL_SETTINGS.KEEPALIVE
        }),
        query: _configSchema.schema.object({}, {
          unknowns: 'allow'
        })
      })
    }
  }, getWatches({
    clusterClient,
    fetchAllFromScroll,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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