"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigService = void 0;
var _lodash = require("lodash");
/* eslint-disable @kbn/eslint/require-license-header */
/* eslint-disable no-restricted-imports */

function assertSearchguardPath(path) {
  if (path.split('.')[0] === 'searchguard') {
    throw new Error('The path must not start with "searchguard".');
  }
}
class ConfigService {
  constructor(config) {
    this.config = config;
  }
  get(path, defaultValue) {
    return (0, _lodash.get)(this.getConfig(), path, defaultValue);
  }
  getConfig() {
    return (0, _lodash.cloneDeep)(this.config);
  }
  getSearchguardConfig(path = '', defaultValue) {
    assertSearchguardPath(path);
    path = path ? `searchguard.${path}` : 'searchguard';
    return this.get(path, defaultValue);
  }
  set(path, value) {
    (0, _lodash.set)(this.config, path, value);
  }
  setSearchguardConfig(path, value) {
    assertSearchguardPath(path);
    this.set(`searchguard.${path}`, value);
  }
}
exports.ConfigService = ConfigService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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