"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAccount = void 0;
exports.createAccountRoute = createAccountRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const createAccount = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      body = {},
      params: {
        id,
        type
      }
    } = request;
    const path = `/_signals/account/${encodeURIComponent(type)}/${encodeURIComponent(id)}`;
    const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
      method: 'put',
      path,
      body
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`createAccount: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.createAccount = createAccount;
function createAccountRoute({
  router,
  clusterClient,
  logger
}) {
  router.put({
    path: `${_constants.ROUTE_PATH.ACCOUNT}/{type}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      }),
      body: _configSchema.schema.object({
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })
    }
  }, createAccount({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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