"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.ConfigSchema = void 0;
exports.plugin = plugin;
var _configSchema = require("@kbn/config-schema");
var _serverPlugin = require("./serverPlugin");
var _package = require("../package.json");
var _default_config = require("./default_config");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const {
  searchguard: {
    cookie: cookieDefaults,
    auth: authDefaults,
    basicauth: basicauthDefaults,
    multitenancy: multitenancyDefaults,
    ...searchguardDefaults
  } = {}
} = _default_config.DEFAULT_CONFIG;

// @todo We need to go through all of these and double check the default values, nullable, allow empty string etc.
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: searchguardDefaults.enabled
  }),
  sg_frontend_config_id: _configSchema.schema.string({
    defaultValue: searchguardDefaults.sg_frontend_config_id
  }),
  frontend_base_url: _configSchema.schema.string({
    defaultValue: searchguardDefaults.frontend_base_url
  }),
  allow_client_certificates: _configSchema.schema.boolean({
    defaultValue: searchguardDefaults.allow_client_certificates
  }),
  readonly_mode: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: searchguardDefaults.readonly_mode.enabled
    }),
    roles: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: searchguardDefaults.readonly_mode.roles
    })
  }),
  xff: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: searchguardDefaults.xff.enabled
    })
  }),
  cookie: _configSchema.schema.object({
    secure: _configSchema.schema.boolean({
      defaultValue: cookieDefaults.secure
    }),
    name: _configSchema.schema.string({
      defaultValue: cookieDefaults.name
    }),
    password: _configSchema.schema.string({
      minLength: 32,
      defaultValue: cookieDefaults.password
    }),
    ttl: _configSchema.schema.nullable(_configSchema.schema.number({
      defaultValue: cookieDefaults.ttl
    })),
    domain: _configSchema.schema.maybe(_configSchema.schema.string()),
    isSameSite: _configSchema.schema.oneOf([
    // @todo Check the changes in Chrome 80 here - more values needed? Compare with hapi-auth-cookie
    _configSchema.schema.literal('None'), _configSchema.schema.literal('Strict'), _configSchema.schema.literal('Lax')], {
      defaultValue: cookieDefaults.isSameSite
    })
  }),
  /**
   * General auth
   */
  auth: _configSchema.schema.object({
    type: _configSchema.schema.oneOf([_configSchema.schema.literal('default'), _configSchema.schema.literal('proxy'), _configSchema.schema.literal('kerberos')], {
      defaultValue: authDefaults.type
    }),
    anonymous_auth_enabled: _configSchema.schema.boolean({
      defaultValue: authDefaults.anonymous_auth_enabled
    }),
    unauthenticated_routes: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: authDefaults.unauthenticated_routes
    }),
    /*
      Caution: Enabling this may cause sensitive authentication information (e.g. credentials) to be logged
    */
    debug: _configSchema.schema.boolean({
      defaultValue: authDefaults.debug
    }),
    jwt_param: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: authDefaults.jwt_param.enabled
      }),
      url_param: _configSchema.schema.string({
        defaultValue: authDefaults.jwt_param.url_param
      })
    })
  }),
  /**
   * Basic auth
   */
  basicauth: _configSchema.schema.object({
    forbidden_usernames: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: basicauthDefaults.forbidden_usernames
    }),
    allowed_usernames: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }),
  /**
   * Multitenancy
   */
  multitenancy: _configSchema.schema.object({
    debug: _configSchema.schema.boolean({
      defaultValue: multitenancyDefaults.debug
    })
  }),
  configuration: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: searchguardDefaults.configuration.enabled
    }),
    action_groups_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.action_groups_page.enabled
      })
    }),
    create_action_groups_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_action_groups_page.enabled
      })
    }),
    internal_users_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.internal_users_page.enabled
      })
    }),
    create_internal_users_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_internal_users_page.enabled
      })
    }),
    roles_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.roles_page.enabled
      })
    }),
    create_roles_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_roles_page.enabled
      })
    }),
    role_mappings_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.role_mappings_page.enabled
      })
    }),
    create_role_mappings_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_role_mappings_page.enabled
      })
    }),
    tenants_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.tenants_page.enabled
      })
    }),
    create_tenants_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.create_tenants_page.enabled
      })
    }),
    system_status_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.system_status_page.enabled
      })
    }),
    license_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.license_page.enabled
      })
    }),
    cache_page: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: searchguardDefaults.configuration.cache_page.enabled
      })
    })
  }),
  accountinfo: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: searchguardDefaults.accountinfo.enabled
    })
  }),
  sgVersion: _configSchema.schema.string({
    defaultValue: _package.version
  })
});
const config = exports.config = {
  exposeToBrowser: {
    auth: true,
    multitenancy: true,
    basicauth: true,
    configuration: true,
    accountinfo: true,
    readonly_mode: true,
    sgVersion: true
  },
  schema: ConfigSchema,
  deprecations: ({
    unusedFromRoot
  }) => {
    return [];
  }
};
function plugin(initializerContext) {
  return new _serverPlugin.ServerPlugin(initializerContext);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9zZXJ2ZXJQbHVnaW4iLCJfcGFja2FnZSIsIl9kZWZhdWx0X2NvbmZpZyIsInNlYXJjaGd1YXJkIiwiY29va2llIiwiY29va2llRGVmYXVsdHMiLCJhdXRoIiwiYXV0aERlZmF1bHRzIiwiYmFzaWNhdXRoIiwiYmFzaWNhdXRoRGVmYXVsdHMiLCJtdWx0aXRlbmFuY3kiLCJtdWx0aXRlbmFuY3lEZWZhdWx0cyIsInNlYXJjaGd1YXJkRGVmYXVsdHMiLCJERUZBVUxUX0NPTkZJRyIsIkNvbmZpZ1NjaGVtYSIsImV4cG9ydHMiLCJzY2hlbWEiLCJvYmplY3QiLCJlbmFibGVkIiwiYm9vbGVhbiIsImRlZmF1bHRWYWx1ZSIsInNnX2Zyb250ZW5kX2NvbmZpZ19pZCIsInN0cmluZyIsImZyb250ZW5kX2Jhc2VfdXJsIiwiYWxsb3dfY2xpZW50X2NlcnRpZmljYXRlcyIsInJlYWRvbmx5X21vZGUiLCJyb2xlcyIsImFycmF5T2YiLCJ4ZmYiLCJzZWN1cmUiLCJuYW1lIiwicGFzc3dvcmQiLCJtaW5MZW5ndGgiLCJ0dGwiLCJudWxsYWJsZSIsIm51bWJlciIsImRvbWFpbiIsIm1heWJlIiwiaXNTYW1lU2l0ZSIsIm9uZU9mIiwibGl0ZXJhbCIsInR5cGUiLCJhbm9ueW1vdXNfYXV0aF9lbmFibGVkIiwidW5hdXRoZW50aWNhdGVkX3JvdXRlcyIsImRlYnVnIiwiand0X3BhcmFtIiwidXJsX3BhcmFtIiwiZm9yYmlkZGVuX3VzZXJuYW1lcyIsImFsbG93ZWRfdXNlcm5hbWVzIiwiY29uZmlndXJhdGlvbiIsImFjdGlvbl9ncm91cHNfcGFnZSIsImNyZWF0ZV9hY3Rpb25fZ3JvdXBzX3BhZ2UiLCJpbnRlcm5hbF91c2Vyc19wYWdlIiwiY3JlYXRlX2ludGVybmFsX3VzZXJzX3BhZ2UiLCJyb2xlc19wYWdlIiwiY3JlYXRlX3JvbGVzX3BhZ2UiLCJyb2xlX21hcHBpbmdzX3BhZ2UiLCJjcmVhdGVfcm9sZV9tYXBwaW5nc19wYWdlIiwidGVuYW50c19wYWdlIiwiY3JlYXRlX3RlbmFudHNfcGFnZSIsInN5c3RlbV9zdGF0dXNfcGFnZSIsImxpY2Vuc2VfcGFnZSIsImNhY2hlX3BhZ2UiLCJhY2NvdW50aW5mbyIsInNnVmVyc2lvbiIsImNvbmZpZyIsImV4cG9zZVRvQnJvd3NlciIsImRlcHJlY2F0aW9ucyIsInVudXNlZEZyb21Sb290IiwicGx1Z2luIiwiaW5pdGlhbGl6ZXJDb250ZXh0IiwiU2VydmVyUGx1Z2luIl0sInNvdXJjZXMiOlsiaW5kZXguanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqICAgIENvcHlyaWdodCAyMDIwIGZsb3JhZ3VubiBHbWJIXG4gKlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTtcbiAqIHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiAqIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiAqIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuICogU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuICogbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQGtibi9jb25maWctc2NoZW1hJztcbmltcG9ydCB7IFNlcnZlclBsdWdpbiB9IGZyb20gJy4vc2VydmVyUGx1Z2luJztcbmltcG9ydCB7IHZlcnNpb24gYXMgc2dWZXJzaW9uIH0gZnJvbSAnLi4vcGFja2FnZS5qc29uJztcbmltcG9ydCB7IERFRkFVTFRfQ09ORklHIH0gZnJvbSAnLi9kZWZhdWx0X2NvbmZpZyc7XG5cbmNvbnN0IHtcbiAgc2VhcmNoZ3VhcmQ6IHtcbiAgICBjb29raWU6IGNvb2tpZURlZmF1bHRzLFxuICAgIGF1dGg6IGF1dGhEZWZhdWx0cyxcbiAgICBiYXNpY2F1dGg6IGJhc2ljYXV0aERlZmF1bHRzLFxuICAgIG11bHRpdGVuYW5jeTogbXVsdGl0ZW5hbmN5RGVmYXVsdHMsXG4gICAgLi4uc2VhcmNoZ3VhcmREZWZhdWx0c1xuICB9ID0ge30sXG59ID0gREVGQVVMVF9DT05GSUc7XG5cbi8vIEB0b2RvIFdlIG5lZWQgdG8gZ28gdGhyb3VnaCBhbGwgb2YgdGhlc2UgYW5kIGRvdWJsZSBjaGVjayB0aGUgZGVmYXVsdCB2YWx1ZXMsIG51bGxhYmxlLCBhbGxvdyBlbXB0eSBzdHJpbmcgZXRjLlxuZXhwb3J0IGNvbnN0IENvbmZpZ1NjaGVtYSA9IHNjaGVtYS5vYmplY3Qoe1xuICBlbmFibGVkOiBzY2hlbWEuYm9vbGVhbih7IGRlZmF1bHRWYWx1ZTogc2VhcmNoZ3VhcmREZWZhdWx0cy5lbmFibGVkIH0pLFxuXG4gIHNnX2Zyb250ZW5kX2NvbmZpZ19pZDogc2NoZW1hLnN0cmluZyh7IGRlZmF1bHRWYWx1ZTogc2VhcmNoZ3VhcmREZWZhdWx0cy5zZ19mcm9udGVuZF9jb25maWdfaWQgfSksXG5cbiAgZnJvbnRlbmRfYmFzZV91cmw6IHNjaGVtYS5zdHJpbmcoeyBkZWZhdWx0VmFsdWU6IHNlYXJjaGd1YXJkRGVmYXVsdHMuZnJvbnRlbmRfYmFzZV91cmwgfSksXG5cbiAgYWxsb3dfY2xpZW50X2NlcnRpZmljYXRlczogc2NoZW1hLmJvb2xlYW4oe1xuICAgIGRlZmF1bHRWYWx1ZTogc2VhcmNoZ3VhcmREZWZhdWx0cy5hbGxvd19jbGllbnRfY2VydGlmaWNhdGVzLFxuICB9KSxcblxuICByZWFkb25seV9tb2RlOiBzY2hlbWEub2JqZWN0KHtcbiAgICBlbmFibGVkOiBzY2hlbWEuYm9vbGVhbih7IGRlZmF1bHRWYWx1ZTogc2VhcmNoZ3VhcmREZWZhdWx0cy5yZWFkb25seV9tb2RlLmVuYWJsZWQgfSksXG4gICAgcm9sZXM6IHNjaGVtYS5hcnJheU9mKHNjaGVtYS5zdHJpbmcoKSwge1xuICAgICAgZGVmYXVsdFZhbHVlOiBzZWFyY2hndWFyZERlZmF1bHRzLnJlYWRvbmx5X21vZGUucm9sZXMsXG4gICAgfSksXG4gIH0pLFxuXG4gIHhmZjogc2NoZW1hLm9iamVjdCh7XG4gICAgZW5hYmxlZDogc2NoZW1hLmJvb2xlYW4oeyBkZWZhdWx0VmFsdWU6IHNlYXJjaGd1YXJkRGVmYXVsdHMueGZmLmVuYWJsZWQgfSksXG4gIH0pLFxuXG4gIGNvb2tpZTogc2NoZW1hLm9iamVjdCh7XG4gICAgc2VjdXJlOiBzY2hlbWEuYm9vbGVhbih7IGRlZmF1bHRWYWx1ZTogY29va2llRGVmYXVsdHMuc2VjdXJlIH0pLFxuICAgIG5hbWU6IHNjaGVtYS5zdHJpbmcoeyBkZWZhdWx0VmFsdWU6IGNvb2tpZURlZmF1bHRzLm5hbWUgfSksXG4gICAgcGFzc3dvcmQ6IHNjaGVtYS5zdHJpbmcoe1xuICAgICAgbWluTGVuZ3RoOiAzMixcbiAgICAgIGRlZmF1bHRWYWx1ZTogY29va2llRGVmYXVsdHMucGFzc3dvcmQsXG4gICAgfSksXG4gICAgdHRsOiBzY2hlbWEubnVsbGFibGUoc2NoZW1hLm51bWJlcih7IGRlZmF1bHRWYWx1ZTogY29va2llRGVmYXVsdHMudHRsIH0pKSxcbiAgICBkb21haW46IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKCkpLFxuICAgIGlzU2FtZVNpdGU6IHNjaGVtYS5vbmVPZihcbiAgICAgIFtcbiAgICAgICAgLy8gQHRvZG8gQ2hlY2sgdGhlIGNoYW5nZXMgaW4gQ2hyb21lIDgwIGhlcmUgLSBtb3JlIHZhbHVlcyBuZWVkZWQ/IENvbXBhcmUgd2l0aCBoYXBpLWF1dGgtY29va2llXG4gICAgICAgIHNjaGVtYS5saXRlcmFsKCdOb25lJyksXG4gICAgICAgIHNjaGVtYS5saXRlcmFsKCdTdHJpY3QnKSxcbiAgICAgICAgc2NoZW1hLmxpdGVyYWwoJ0xheCcpLFxuICAgICAgXSxcbiAgICAgIHsgZGVmYXVsdFZhbHVlOiBjb29raWVEZWZhdWx0cy5pc1NhbWVTaXRlIH1cbiAgICApLFxuICB9KSxcblxuICAvKipcbiAgICogR2VuZXJhbCBhdXRoXG4gICAqL1xuICBhdXRoOiBzY2hlbWEub2JqZWN0KHtcbiAgICB0eXBlOiBzY2hlbWEub25lT2YoXG4gICAgICBbXG4gICAgICAgIHNjaGVtYS5saXRlcmFsKCdkZWZhdWx0JyksXG4gICAgICAgIHNjaGVtYS5saXRlcmFsKCdwcm94eScpLFxuICAgICAgICBzY2hlbWEubGl0ZXJhbCgna2VyYmVyb3MnKSxcbiAgICAgIF0sXG4gICAgICB7IGRlZmF1bHRWYWx1ZTogYXV0aERlZmF1bHRzLnR5cGUgfVxuICAgICksXG4gICAgYW5vbnltb3VzX2F1dGhfZW5hYmxlZDogc2NoZW1hLmJvb2xlYW4oeyBkZWZhdWx0VmFsdWU6IGF1dGhEZWZhdWx0cy5hbm9ueW1vdXNfYXV0aF9lbmFibGVkIH0pLFxuICAgIHVuYXV0aGVudGljYXRlZF9yb3V0ZXM6IHNjaGVtYS5hcnJheU9mKHNjaGVtYS5zdHJpbmcoKSwge1xuICAgICAgZGVmYXVsdFZhbHVlOiBhdXRoRGVmYXVsdHMudW5hdXRoZW50aWNhdGVkX3JvdXRlcyxcbiAgICB9KSxcbiAgICAvKlxuICAgICAgQ2F1dGlvbjogRW5hYmxpbmcgdGhpcyBtYXkgY2F1c2Ugc2Vuc2l0aXZlIGF1dGhlbnRpY2F0aW9uIGluZm9ybWF0aW9uIChlLmcuIGNyZWRlbnRpYWxzKSB0byBiZSBsb2dnZWRcbiAgICAqL1xuICAgIGRlYnVnOiBzY2hlbWEuYm9vbGVhbih7IGRlZmF1bHRWYWx1ZTogYXV0aERlZmF1bHRzLmRlYnVnIH0pLFxuXG4gICAgand0X3BhcmFtOiBzY2hlbWEub2JqZWN0KHtcbiAgICBcdGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHsgZGVmYXVsdFZhbHVlOiBhdXRoRGVmYXVsdHMuand0X3BhcmFtLmVuYWJsZWQgfSksXG4gICAgXHR1cmxfcGFyYW06IHNjaGVtYS5zdHJpbmcoeyBkZWZhdWx0VmFsdWU6IGF1dGhEZWZhdWx0cy5qd3RfcGFyYW0udXJsX3BhcmFtIH0pXG4gIFx0fSksXG4gIH0pLFxuXG4gIC8qKlxuICAgKiBCYXNpYyBhdXRoXG4gICAqL1xuICBiYXNpY2F1dGg6IHNjaGVtYS5vYmplY3Qoe1xuICAgIGZvcmJpZGRlbl91c2VybmFtZXM6IHNjaGVtYS5hcnJheU9mKHNjaGVtYS5zdHJpbmcoKSwge1xuICAgICAgZGVmYXVsdFZhbHVlOiBiYXNpY2F1dGhEZWZhdWx0cy5mb3JiaWRkZW5fdXNlcm5hbWVzLFxuICAgIH0pLFxuICAgIGFsbG93ZWRfdXNlcm5hbWVzOiBzY2hlbWEubnVsbGFibGUoc2NoZW1hLmFycmF5T2Yoc2NoZW1hLnN0cmluZygpKSksXG5cbiAgfSksXG5cbiAgLyoqXG4gICAqIE11bHRpdGVuYW5jeVxuICAgKi9cbiAgbXVsdGl0ZW5hbmN5OiBzY2hlbWEub2JqZWN0KHtcbiAgICBkZWJ1Zzogc2NoZW1hLmJvb2xlYW4oeyBkZWZhdWx0VmFsdWU6IG11bHRpdGVuYW5jeURlZmF1bHRzLmRlYnVnIH0pLFxuICB9KSxcbiAgY29uZmlndXJhdGlvbjogc2NoZW1hLm9iamVjdCh7XG4gICAgZW5hYmxlZDogc2NoZW1hLmJvb2xlYW4oeyBkZWZhdWx0VmFsdWU6IHNlYXJjaGd1YXJkRGVmYXVsdHMuY29uZmlndXJhdGlvbi5lbmFibGVkIH0pLFxuICAgIGFjdGlvbl9ncm91cHNfcGFnZTogc2NoZW1hLm9iamVjdCh7XG4gICAgICBlbmFibGVkOiBzY2hlbWEuYm9vbGVhbih7XG4gICAgICAgIGRlZmF1bHRWYWx1ZTogc2VhcmNoZ3VhcmREZWZhdWx0cy5jb25maWd1cmF0aW9uLmFjdGlvbl9ncm91cHNfcGFnZS5lbmFibGVkLFxuICAgICAgfSksXG4gICAgfSksXG4gICAgY3JlYXRlX2FjdGlvbl9ncm91cHNfcGFnZTogc2NoZW1hLm9iamVjdCh7XG4gICAgICBlbmFibGVkOiBzY2hlbWEuYm9vbGVhbih7XG4gICAgICAgIGRlZmF1bHRWYWx1ZTogc2VhcmNoZ3VhcmREZWZhdWx0cy5jb25maWd1cmF0aW9uLmNyZWF0ZV9hY3Rpb25fZ3JvdXBzX3BhZ2UuZW5hYmxlZCxcbiAgICAgIH0pLFxuICAgIH0pLFxuICAgIGludGVybmFsX3VzZXJzX3BhZ2U6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgZW5hYmxlZDogc2NoZW1hLmJvb2xlYW4oe1xuICAgICAgICBkZWZhdWx0VmFsdWU6IHNlYXJjaGd1YXJkRGVmYXVsdHMuY29uZmlndXJhdGlvbi5pbnRlcm5hbF91c2Vyc19wYWdlLmVuYWJsZWQsXG4gICAgICB9KSxcbiAgICB9KSxcbiAgICBjcmVhdGVfaW50ZXJuYWxfdXNlcnNfcGFnZTogc2NoZW1hLm9iamVjdCh7XG4gICAgICBlbmFibGVkOiBzY2hlbWEuYm9vbGVhbih7XG4gICAgICAgIGRlZmF1bHRWYWx1ZTogc2VhcmNoZ3VhcmREZWZhdWx0cy5jb25maWd1cmF0aW9uLmNyZWF0ZV9pbnRlcm5hbF91c2Vyc19wYWdlLmVuYWJsZWQsXG4gICAgICB9KSxcbiAgICB9KSxcbiAgICByb2xlc19wYWdlOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHtcbiAgICAgICAgZGVmYXVsdFZhbHVlOiBzZWFyY2hndWFyZERlZmF1bHRzLmNvbmZpZ3VyYXRpb24ucm9sZXNfcGFnZS5lbmFibGVkLFxuICAgICAgfSksXG4gICAgfSksXG4gICAgY3JlYXRlX3JvbGVzX3BhZ2U6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgZW5hYmxlZDogc2NoZW1hLmJvb2xlYW4oe1xuICAgICAgICBkZWZhdWx0VmFsdWU6IHNlYXJjaGd1YXJkRGVmYXVsdHMuY29uZmlndXJhdGlvbi5jcmVhdGVfcm9sZXNfcGFnZS5lbmFibGVkLFxuICAgICAgfSksXG4gICAgfSksXG4gICAgcm9sZV9tYXBwaW5nc19wYWdlOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHtcbiAgICAgICAgZGVmYXVsdFZhbHVlOiBzZWFyY2hndWFyZERlZmF1bHRzLmNvbmZpZ3VyYXRpb24ucm9sZV9tYXBwaW5nc19wYWdlLmVuYWJsZWQsXG4gICAgICB9KSxcbiAgICB9KSxcbiAgICBjcmVhdGVfcm9sZV9tYXBwaW5nc19wYWdlOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHtcbiAgICAgICAgZGVmYXVsdFZhbHVlOiBzZWFyY2hndWFyZERlZmF1bHRzLmNvbmZpZ3VyYXRpb24uY3JlYXRlX3JvbGVfbWFwcGluZ3NfcGFnZS5lbmFibGVkLFxuICAgICAgfSksXG4gICAgfSksXG4gICAgdGVuYW50c19wYWdlOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHtcbiAgICAgICAgZGVmYXVsdFZhbHVlOiBzZWFyY2hndWFyZERlZmF1bHRzLmNvbmZpZ3VyYXRpb24udGVuYW50c19wYWdlLmVuYWJsZWQsXG4gICAgICB9KSxcbiAgICB9KSxcbiAgICBjcmVhdGVfdGVuYW50c19wYWdlOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHtcbiAgICAgICAgZGVmYXVsdFZhbHVlOiBzZWFyY2hndWFyZERlZmF1bHRzLmNvbmZpZ3VyYXRpb24uY3JlYXRlX3RlbmFudHNfcGFnZS5lbmFibGVkLFxuICAgICAgfSksXG4gICAgfSksXG4gICAgc3lzdGVtX3N0YXR1c19wYWdlOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHtcbiAgICAgICAgZGVmYXVsdFZhbHVlOiBzZWFyY2hndWFyZERlZmF1bHRzLmNvbmZpZ3VyYXRpb24uc3lzdGVtX3N0YXR1c19wYWdlLmVuYWJsZWQsXG4gICAgICB9KSxcbiAgICB9KSxcbiAgICBsaWNlbnNlX3BhZ2U6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgZW5hYmxlZDogc2NoZW1hLmJvb2xlYW4oe1xuICAgICAgICBkZWZhdWx0VmFsdWU6IHNlYXJjaGd1YXJkRGVmYXVsdHMuY29uZmlndXJhdGlvbi5saWNlbnNlX3BhZ2UuZW5hYmxlZCxcbiAgICAgIH0pLFxuICAgIH0pLFxuICAgIGNhY2hlX3BhZ2U6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgZW5hYmxlZDogc2NoZW1hLmJvb2xlYW4oe1xuICAgICAgICBkZWZhdWx0VmFsdWU6IHNlYXJjaGd1YXJkRGVmYXVsdHMuY29uZmlndXJhdGlvbi5jYWNoZV9wYWdlLmVuYWJsZWQsXG4gICAgICB9KSxcbiAgICB9KSxcbiAgfSksXG5cbiAgYWNjb3VudGluZm86IHNjaGVtYS5vYmplY3Qoe1xuICAgIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHsgZGVmYXVsdFZhbHVlOiBzZWFyY2hndWFyZERlZmF1bHRzLmFjY291bnRpbmZvLmVuYWJsZWQgfSksXG4gIH0pLFxuXG4gIHNnVmVyc2lvbjogc2NoZW1hLnN0cmluZyh7IGRlZmF1bHRWYWx1ZTogc2dWZXJzaW9uIH0pLFxufSk7XG5cbmV4cG9ydCBjb25zdCBjb25maWcgPSB7XG4gIGV4cG9zZVRvQnJvd3Nlcjoge1xuICAgIGF1dGg6IHRydWUsXG4gICAgbXVsdGl0ZW5hbmN5OiB0cnVlLFxuICAgIGJhc2ljYXV0aDogdHJ1ZSxcbiAgICBjb25maWd1cmF0aW9uOiB0cnVlLFxuICAgIGFjY291bnRpbmZvOiB0cnVlLFxuICAgIHJlYWRvbmx5X21vZGU6IHRydWUsXG4gICAgc2dWZXJzaW9uOiB0cnVlLFxuICB9LFxuICBzY2hlbWE6IENvbmZpZ1NjaGVtYSxcbiAgZGVwcmVjYXRpb25zOiAoeyB1bnVzZWRGcm9tUm9vdCB9KSA9PiB7XG4gICAgcmV0dXJuIFtdO1xuICB9LFxufTtcblxuZXhwb3J0IGZ1bmN0aW9uIHBsdWdpbihpbml0aWFsaXplckNvbnRleHQpIHtcbiAgcmV0dXJuIG5ldyBTZXJ2ZXJQbHVnaW4oaW5pdGlhbGl6ZXJDb250ZXh0KTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQWdCQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFDQSxJQUFBQyxhQUFBLEdBQUFELE9BQUE7QUFDQSxJQUFBRSxRQUFBLEdBQUFGLE9BQUE7QUFDQSxJQUFBRyxlQUFBLEdBQUFILE9BQUE7QUFuQkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQU9BLE1BQU07RUFDSkksV0FBVyxFQUFFO0lBQ1hDLE1BQU0sRUFBRUMsY0FBYztJQUN0QkMsSUFBSSxFQUFFQyxZQUFZO0lBQ2xCQyxTQUFTLEVBQUVDLGlCQUFpQjtJQUM1QkMsWUFBWSxFQUFFQyxvQkFBb0I7SUFDbEMsR0FBR0M7RUFDTCxDQUFDLEdBQUcsQ0FBQztBQUNQLENBQUMsR0FBR0MsOEJBQWM7O0FBRWxCO0FBQ08sTUFBTUMsWUFBWSxHQUFBQyxPQUFBLENBQUFELFlBQUEsR0FBR0Usb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO0VBQ3hDQyxPQUFPLEVBQUVGLG9CQUFNLENBQUNHLE9BQU8sQ0FBQztJQUFFQyxZQUFZLEVBQUVSLG1CQUFtQixDQUFDTTtFQUFRLENBQUMsQ0FBQztFQUV0RUcscUJBQXFCLEVBQUVMLG9CQUFNLENBQUNNLE1BQU0sQ0FBQztJQUFFRixZQUFZLEVBQUVSLG1CQUFtQixDQUFDUztFQUFzQixDQUFDLENBQUM7RUFFakdFLGlCQUFpQixFQUFFUCxvQkFBTSxDQUFDTSxNQUFNLENBQUM7SUFBRUYsWUFBWSxFQUFFUixtQkFBbUIsQ0FBQ1c7RUFBa0IsQ0FBQyxDQUFDO0VBRXpGQyx5QkFBeUIsRUFBRVIsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO0lBQ3hDQyxZQUFZLEVBQUVSLG1CQUFtQixDQUFDWTtFQUNwQyxDQUFDLENBQUM7RUFFRkMsYUFBYSxFQUFFVCxvQkFBTSxDQUFDQyxNQUFNLENBQUM7SUFDM0JDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO01BQUVDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNhLGFBQWEsQ0FBQ1A7SUFBUSxDQUFDLENBQUM7SUFDcEZRLEtBQUssRUFBRVYsb0JBQU0sQ0FBQ1csT0FBTyxDQUFDWCxvQkFBTSxDQUFDTSxNQUFNLENBQUMsQ0FBQyxFQUFFO01BQ3JDRixZQUFZLEVBQUVSLG1CQUFtQixDQUFDYSxhQUFhLENBQUNDO0lBQ2xELENBQUM7RUFDSCxDQUFDLENBQUM7RUFFRkUsR0FBRyxFQUFFWixvQkFBTSxDQUFDQyxNQUFNLENBQUM7SUFDakJDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO01BQUVDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNnQixHQUFHLENBQUNWO0lBQVEsQ0FBQztFQUMzRSxDQUFDLENBQUM7RUFFRmQsTUFBTSxFQUFFWSxvQkFBTSxDQUFDQyxNQUFNLENBQUM7SUFDcEJZLE1BQU0sRUFBRWIsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO01BQUVDLFlBQVksRUFBRWYsY0FBYyxDQUFDd0I7SUFBTyxDQUFDLENBQUM7SUFDL0RDLElBQUksRUFBRWQsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO01BQUVGLFlBQVksRUFBRWYsY0FBYyxDQUFDeUI7SUFBSyxDQUFDLENBQUM7SUFDMURDLFFBQVEsRUFBRWYsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDO01BQ3RCVSxTQUFTLEVBQUUsRUFBRTtNQUNiWixZQUFZLEVBQUVmLGNBQWMsQ0FBQzBCO0lBQy9CLENBQUMsQ0FBQztJQUNGRSxHQUFHLEVBQUVqQixvQkFBTSxDQUFDa0IsUUFBUSxDQUFDbEIsb0JBQU0sQ0FBQ21CLE1BQU0sQ0FBQztNQUFFZixZQUFZLEVBQUVmLGNBQWMsQ0FBQzRCO0lBQUksQ0FBQyxDQUFDLENBQUM7SUFDekVHLE1BQU0sRUFBRXBCLG9CQUFNLENBQUNxQixLQUFLLENBQUNyQixvQkFBTSxDQUFDTSxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3JDZ0IsVUFBVSxFQUFFdEIsb0JBQU0sQ0FBQ3VCLEtBQUssQ0FDdEI7SUFDRTtJQUNBdkIsb0JBQU0sQ0FBQ3dCLE9BQU8sQ0FBQyxNQUFNLENBQUMsRUFDdEJ4QixvQkFBTSxDQUFDd0IsT0FBTyxDQUFDLFFBQVEsQ0FBQyxFQUN4QnhCLG9CQUFNLENBQUN3QixPQUFPLENBQUMsS0FBSyxDQUFDLENBQ3RCLEVBQ0Q7TUFBRXBCLFlBQVksRUFBRWYsY0FBYyxDQUFDaUM7SUFBVyxDQUM1QztFQUNGLENBQUMsQ0FBQztFQUVGO0FBQ0Y7QUFDQTtFQUNFaEMsSUFBSSxFQUFFVSxvQkFBTSxDQUFDQyxNQUFNLENBQUM7SUFDbEJ3QixJQUFJLEVBQUV6QixvQkFBTSxDQUFDdUIsS0FBSyxDQUNoQixDQUNFdkIsb0JBQU0sQ0FBQ3dCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDekJ4QixvQkFBTSxDQUFDd0IsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUN2QnhCLG9CQUFNLENBQUN3QixPQUFPLENBQUMsVUFBVSxDQUFDLENBQzNCLEVBQ0Q7TUFBRXBCLFlBQVksRUFBRWIsWUFBWSxDQUFDa0M7SUFBSyxDQUNwQyxDQUFDO0lBQ0RDLHNCQUFzQixFQUFFMUIsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO01BQUVDLFlBQVksRUFBRWIsWUFBWSxDQUFDbUM7SUFBdUIsQ0FBQyxDQUFDO0lBQzdGQyxzQkFBc0IsRUFBRTNCLG9CQUFNLENBQUNXLE9BQU8sQ0FBQ1gsb0JBQU0sQ0FBQ00sTUFBTSxDQUFDLENBQUMsRUFBRTtNQUN0REYsWUFBWSxFQUFFYixZQUFZLENBQUNvQztJQUM3QixDQUFDLENBQUM7SUFDRjtBQUNKO0FBQ0E7SUFDSUMsS0FBSyxFQUFFNUIsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO01BQUVDLFlBQVksRUFBRWIsWUFBWSxDQUFDcUM7SUFBTSxDQUFDLENBQUM7SUFFM0RDLFNBQVMsRUFBRTdCLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztNQUN4QkMsT0FBTyxFQUFFRixvQkFBTSxDQUFDRyxPQUFPLENBQUM7UUFBRUMsWUFBWSxFQUFFYixZQUFZLENBQUNzQyxTQUFTLENBQUMzQjtNQUFRLENBQUMsQ0FBQztNQUN6RTRCLFNBQVMsRUFBRTlCLG9CQUFNLENBQUNNLE1BQU0sQ0FBQztRQUFFRixZQUFZLEVBQUViLFlBQVksQ0FBQ3NDLFNBQVMsQ0FBQ0M7TUFBVSxDQUFDO0lBQzdFLENBQUM7RUFDRixDQUFDLENBQUM7RUFFRjtBQUNGO0FBQ0E7RUFDRXRDLFNBQVMsRUFBRVEsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO0lBQ3ZCOEIsbUJBQW1CLEVBQUUvQixvQkFBTSxDQUFDVyxPQUFPLENBQUNYLG9CQUFNLENBQUNNLE1BQU0sQ0FBQyxDQUFDLEVBQUU7TUFDbkRGLFlBQVksRUFBRVgsaUJBQWlCLENBQUNzQztJQUNsQyxDQUFDLENBQUM7SUFDRkMsaUJBQWlCLEVBQUVoQyxvQkFBTSxDQUFDa0IsUUFBUSxDQUFDbEIsb0JBQU0sQ0FBQ1csT0FBTyxDQUFDWCxvQkFBTSxDQUFDTSxNQUFNLENBQUMsQ0FBQyxDQUFDO0VBRXBFLENBQUMsQ0FBQztFQUVGO0FBQ0Y7QUFDQTtFQUNFWixZQUFZLEVBQUVNLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztJQUMxQjJCLEtBQUssRUFBRTVCLG9CQUFNLENBQUNHLE9BQU8sQ0FBQztNQUFFQyxZQUFZLEVBQUVULG9CQUFvQixDQUFDaUM7SUFBTSxDQUFDO0VBQ3BFLENBQUMsQ0FBQztFQUNGSyxhQUFhLEVBQUVqQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7SUFDM0JDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO01BQUVDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNxQyxhQUFhLENBQUMvQjtJQUFRLENBQUMsQ0FBQztJQUNwRmdDLGtCQUFrQixFQUFFbEMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO01BQ2hDQyxPQUFPLEVBQUVGLG9CQUFNLENBQUNHLE9BQU8sQ0FBQztRQUN0QkMsWUFBWSxFQUFFUixtQkFBbUIsQ0FBQ3FDLGFBQWEsQ0FBQ0Msa0JBQWtCLENBQUNoQztNQUNyRSxDQUFDO0lBQ0gsQ0FBQyxDQUFDO0lBQ0ZpQyx5QkFBeUIsRUFBRW5DLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztNQUN2Q0MsT0FBTyxFQUFFRixvQkFBTSxDQUFDRyxPQUFPLENBQUM7UUFDdEJDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNxQyxhQUFhLENBQUNFLHlCQUF5QixDQUFDakM7TUFDNUUsQ0FBQztJQUNILENBQUMsQ0FBQztJQUNGa0MsbUJBQW1CLEVBQUVwQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7TUFDakNDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO1FBQ3RCQyxZQUFZLEVBQUVSLG1CQUFtQixDQUFDcUMsYUFBYSxDQUFDRyxtQkFBbUIsQ0FBQ2xDO01BQ3RFLENBQUM7SUFDSCxDQUFDLENBQUM7SUFDRm1DLDBCQUEwQixFQUFFckMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO01BQ3hDQyxPQUFPLEVBQUVGLG9CQUFNLENBQUNHLE9BQU8sQ0FBQztRQUN0QkMsWUFBWSxFQUFFUixtQkFBbUIsQ0FBQ3FDLGFBQWEsQ0FBQ0ksMEJBQTBCLENBQUNuQztNQUM3RSxDQUFDO0lBQ0gsQ0FBQyxDQUFDO0lBQ0ZvQyxVQUFVLEVBQUV0QyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7TUFDeEJDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO1FBQ3RCQyxZQUFZLEVBQUVSLG1CQUFtQixDQUFDcUMsYUFBYSxDQUFDSyxVQUFVLENBQUNwQztNQUM3RCxDQUFDO0lBQ0gsQ0FBQyxDQUFDO0lBQ0ZxQyxpQkFBaUIsRUFBRXZDLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztNQUMvQkMsT0FBTyxFQUFFRixvQkFBTSxDQUFDRyxPQUFPLENBQUM7UUFDdEJDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNxQyxhQUFhLENBQUNNLGlCQUFpQixDQUFDckM7TUFDcEUsQ0FBQztJQUNILENBQUMsQ0FBQztJQUNGc0Msa0JBQWtCLEVBQUV4QyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7TUFDaENDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO1FBQ3RCQyxZQUFZLEVBQUVSLG1CQUFtQixDQUFDcUMsYUFBYSxDQUFDTyxrQkFBa0IsQ0FBQ3RDO01BQ3JFLENBQUM7SUFDSCxDQUFDLENBQUM7SUFDRnVDLHlCQUF5QixFQUFFekMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO01BQ3ZDQyxPQUFPLEVBQUVGLG9CQUFNLENBQUNHLE9BQU8sQ0FBQztRQUN0QkMsWUFBWSxFQUFFUixtQkFBbUIsQ0FBQ3FDLGFBQWEsQ0FBQ1EseUJBQXlCLENBQUN2QztNQUM1RSxDQUFDO0lBQ0gsQ0FBQyxDQUFDO0lBQ0Z3QyxZQUFZLEVBQUUxQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7TUFDMUJDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO1FBQ3RCQyxZQUFZLEVBQUVSLG1CQUFtQixDQUFDcUMsYUFBYSxDQUFDUyxZQUFZLENBQUN4QztNQUMvRCxDQUFDO0lBQ0gsQ0FBQyxDQUFDO0lBQ0Z5QyxtQkFBbUIsRUFBRTNDLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztNQUNqQ0MsT0FBTyxFQUFFRixvQkFBTSxDQUFDRyxPQUFPLENBQUM7UUFDdEJDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNxQyxhQUFhLENBQUNVLG1CQUFtQixDQUFDekM7TUFDdEUsQ0FBQztJQUNILENBQUMsQ0FBQztJQUNGMEMsa0JBQWtCLEVBQUU1QyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7TUFDaENDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO1FBQ3RCQyxZQUFZLEVBQUVSLG1CQUFtQixDQUFDcUMsYUFBYSxDQUFDVyxrQkFBa0IsQ0FBQzFDO01BQ3JFLENBQUM7SUFDSCxDQUFDLENBQUM7SUFDRjJDLFlBQVksRUFBRTdDLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztNQUMxQkMsT0FBTyxFQUFFRixvQkFBTSxDQUFDRyxPQUFPLENBQUM7UUFDdEJDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNxQyxhQUFhLENBQUNZLFlBQVksQ0FBQzNDO01BQy9ELENBQUM7SUFDSCxDQUFDLENBQUM7SUFDRjRDLFVBQVUsRUFBRTlDLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztNQUN4QkMsT0FBTyxFQUFFRixvQkFBTSxDQUFDRyxPQUFPLENBQUM7UUFDdEJDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNxQyxhQUFhLENBQUNhLFVBQVUsQ0FBQzVDO01BQzdELENBQUM7SUFDSCxDQUFDO0VBQ0gsQ0FBQyxDQUFDO0VBRUY2QyxXQUFXLEVBQUUvQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7SUFDekJDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csT0FBTyxDQUFDO01BQUVDLFlBQVksRUFBRVIsbUJBQW1CLENBQUNtRCxXQUFXLENBQUM3QztJQUFRLENBQUM7RUFDbkYsQ0FBQyxDQUFDO0VBRUY4QyxTQUFTLEVBQUVoRCxvQkFBTSxDQUFDTSxNQUFNLENBQUM7SUFBRUYsWUFBWSxFQUFFNEM7RUFBVSxDQUFDO0FBQ3RELENBQUMsQ0FBQztBQUVLLE1BQU1DLE1BQU0sR0FBQWxELE9BQUEsQ0FBQWtELE1BQUEsR0FBRztFQUNwQkMsZUFBZSxFQUFFO0lBQ2Y1RCxJQUFJLEVBQUUsSUFBSTtJQUNWSSxZQUFZLEVBQUUsSUFBSTtJQUNsQkYsU0FBUyxFQUFFLElBQUk7SUFDZnlDLGFBQWEsRUFBRSxJQUFJO0lBQ25CYyxXQUFXLEVBQUUsSUFBSTtJQUNqQnRDLGFBQWEsRUFBRSxJQUFJO0lBQ25CdUMsU0FBUyxFQUFFO0VBQ2IsQ0FBQztFQUNEaEQsTUFBTSxFQUFFRixZQUFZO0VBQ3BCcUQsWUFBWSxFQUFFQSxDQUFDO0lBQUVDO0VBQWUsQ0FBQyxLQUFLO0lBQ3BDLE9BQU8sRUFBRTtFQUNYO0FBQ0YsQ0FBQztBQUVNLFNBQVNDLE1BQU1BLENBQUNDLGtCQUFrQixFQUFFO0VBQ3pDLE9BQU8sSUFBSUMsMEJBQVksQ0FBQ0Qsa0JBQWtCLENBQUM7QUFDN0MiLCJpZ25vcmVMaXN0IjpbXX0=