"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TenantService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

class TenantService {
  constructor({
    clusterClient,
    logger,
    configService,
    savedObjects,
    coreContext
  }) {
    (0, _defineProperty2.default)(this, "logErrorDetails", (error, message) => {
      if (!message) message = error.message;
      let errorMeta = JSON.stringify((0, _lodash.get)(error, 'meta.body', ''));
      if (!errorMeta || !errorMeta.length) errorMeta = error;
      this.logger.error(`${message}, ${errorMeta}`);
    });
    (0, _defineProperty2.default)(this, "indexExists", async ({
      request,
      indexName
    }) => {
      try {
        await this.clusterClient.asScoped(request).asCurrentUser.transport.request({
          method: 'get',
          path: `/${indexName}`
        });
        return true;
      } catch (error) {
        if (error.meta.statusCode === 404) {
          return false;
        } else {
          this.logErrorDetails(error, `Fail to verify index "${indexName}"`);
        }
      }
      return false;
    });
    (0, _defineProperty2.default)(this, "docExists", async ({
      request,
      indexName,
      docId
    }) => {
      try {
        await this.clusterClient.asScoped(request).asCurrentUser.transport.request({
          method: 'get',
          path: `/${indexName}/_doc/${docId}`
        });
        return true;
      } catch (error) {
        if (error.meta.statusCode === 404) {
          return false;
        } else {
          this.logErrorDetails(error, `Fail to verify doc "${docId}"`);
        }
      }
      return false;
    });
    (0, _defineProperty2.default)(this, "createDoc", async ({
      request,
      tenantName,
      versionIndexName,
      docId,
      docBody,
      refresh = true
    } = {}) => {
      try {
        // Create doc and index
        await this.clusterClient.asScoped(request).asCurrentUser.create({
          id: docId,
          body: docBody,
          index: this.aliasName,
          refresh
        });
      } catch (error) {
        const docExists = (0, _lodash.get)(error, 'meta.statusCode') === 409;
        if (!docExists) {
          this.logErrorDetails(error, `Fail to create the doc "${docId}" for tenant "${tenantName}" in index ${versionIndexName}`);
        }
      }
    });
    this.kibanaVersion = coreContext.env.packageInfo.version;
    this.clusterClient = clusterClient;
    this.logger = logger;
    this.configService = configService;
    this.aliasName = this.configService.get('kibana.index');
    this.versionAliasName = this.aliasName + `_${this.kibanaVersion}`;
    this.versionIndexName = this.versionAliasName + '_001';
  }
}
exports.TenantService = TenantService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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