"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccounts = void 0;
exports.getAccountsRoute = getAccountsRoute;
var _configSchema = require("@kbn/config-schema");
var _lib = require("../../lib");
var _helpers = require("../../lib/helpers");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getAccounts = ({
  clusterClient,
  fetchAllFromScroll,
  logger
}) => async (context, request, response) => {
  try {
    const {
      body: {
        query,
        scroll
      }
    } = request;
    const body = {};
    if (query && !!Object.keys(query).length) {
      body.query = query;
    }
    const firstScrollResponse = await clusterClient.asScoped(request).asCurrentUser.transport.request({
      method: 'post',
      path: `/_signals/account/_search?scroll=${scroll}`,
      body
    });
    const hits = await fetchAllFromScroll({
      clusterClient,
      scroll,
      request,
      response: firstScrollResponse
    });
    return response.ok({
      body: {
        ok: true,
        resp: hits.map(({
          _source,
          _id
        }) => ({
          ..._source,
          _id: (0, _helpers.getId)(_id)
        }))
      }
    });
  } catch (err) {
    logger.error(`getAccounts: ${err.stack}`);
    return response.customError((0, _lib.serverError)(err));
  }
};
exports.getAccounts = getAccounts;
function getAccountsRoute({
  router,
  clusterClient,
  fetchAllFromScroll,
  logger
}) {
  router.post({
    path: _constants.ROUTE_PATH.ACCOUNTS,
    validate: {
      body: _configSchema.schema.object({
        scroll: _configSchema.schema.string({
          defaultValue: _constants.ES_SCROLL_SETTINGS.KEEPALIVE
        }),
        query: _configSchema.schema.object({}, {
          unknowns: 'allow'
        })
      }, {
        unknowns: 'allow'
      })
    }
  }, getAccounts({
    clusterClient,
    fetchAllFromScroll,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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