"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWatch = getWatch;
exports.getWatchRoute = getWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _helpers = require("../../lib/helpers");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function getWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        params: {
          id
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(id)}`;
      const {
        _source,
        _id
      } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'get',
        path
      });
      return response.ok({
        body: {
          ok: true,
          resp: {
            ..._source,
            _id: (0, _helpers.getId)(_id)
          }
        }
      });
    } catch (err) {
      if (err.statusCode !== 404) {
        logger.error(`getWatch: ${err.stack}`);
      }
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function getWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.get({
    path: `${_constants.ROUTE_PATH.WATCH}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, getWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9lcnJvcnMiLCJfaGVscGVycyIsIl9jb25zdGFudHMiLCJnZXRXYXRjaCIsImNsdXN0ZXJDbGllbnQiLCJsb2dnZXIiLCJjb250ZXh0IiwicmVxdWVzdCIsInJlc3BvbnNlIiwicGFyYW1zIiwiaWQiLCJoZWFkZXJzIiwic2d0ZW5hbnQiLCJOT19NVUxUSVRFTkFOQ1lfVEVOQU5UIiwicGF0aCIsImVuY29kZVVSSUNvbXBvbmVudCIsIl9zb3VyY2UiLCJfaWQiLCJhc1Njb3BlZCIsImFzQ3VycmVudFVzZXIiLCJ0cmFuc3BvcnQiLCJtZXRob2QiLCJvayIsImJvZHkiLCJyZXNwIiwiZ2V0SWQiLCJlcnIiLCJzdGF0dXNDb2RlIiwiZXJyb3IiLCJzdGFjayIsImN1c3RvbUVycm9yIiwic2VydmVyRXJyb3IiLCJnZXRXYXRjaFJvdXRlIiwicm91dGVyIiwiZ2V0IiwiUk9VVEVfUEFUSCIsIldBVENIIiwidmFsaWRhdGUiLCJzY2hlbWEiLCJvYmplY3QiLCJzdHJpbmciXSwic291cmNlcyI6WyJnZXQuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqICAgIENvcHlyaWdodCAyMDIwIGZsb3JhZ3VubiBHbWJIXG4gKlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTtcbiAqIHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiAqIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiAqIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuICogU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuICogbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQGtibi9jb25maWctc2NoZW1hJztcbmltcG9ydCB7IHNlcnZlckVycm9yIH0gZnJvbSAnLi4vLi4vbGliL2Vycm9ycyc7XG5pbXBvcnQgeyBnZXRJZCB9IGZyb20gJy4uLy4uL2xpYi9oZWxwZXJzJztcbmltcG9ydCB7IFJPVVRFX1BBVEgsIE5PX01VTFRJVEVOQU5DWV9URU5BTlQgfSBmcm9tICcuLi8uLi8uLi8uLi8uLi9jb21tb24vc2lnbmFscy9jb25zdGFudHMnO1xuXG5leHBvcnQgZnVuY3Rpb24gZ2V0V2F0Y2goeyBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSkge1xuICByZXR1cm4gYXN5bmMgZnVuY3Rpb24gKGNvbnRleHQsIHJlcXVlc3QsIHJlc3BvbnNlKSB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHtcbiAgICAgICAgcGFyYW1zOiB7IGlkIH0sXG4gICAgICAgIGhlYWRlcnM6IHsgc2d0ZW5hbnQgPSBOT19NVUxUSVRFTkFOQ1lfVEVOQU5UIH0sXG4gICAgICB9ID0gcmVxdWVzdDtcblxuICAgICAgY29uc3QgcGF0aCA9IGAvX3NpZ25hbHMvd2F0Y2gvJHtlbmNvZGVVUklDb21wb25lbnQoc2d0ZW5hbnQpfS8ke2VuY29kZVVSSUNvbXBvbmVudChpZCl9YDtcblxuICAgICAgY29uc3QgeyBfc291cmNlLCBfaWQgfVxuICAgICAgID0gYXdhaXQgY2x1c3RlckNsaWVudC5hc1Njb3BlZChyZXF1ZXN0KS5hc0N1cnJlbnRVc2VyLnRyYW5zcG9ydC5yZXF1ZXN0KHtcbiAgICAgICAgbWV0aG9kOiAnZ2V0JyxcbiAgICAgICAgcGF0aCxcbiAgICAgIH0pO1xuXG4gICAgICByZXR1cm4gcmVzcG9uc2Uub2soeyBib2R5OiB7IG9rOiB0cnVlLCByZXNwOiB7IC4uLl9zb3VyY2UsIF9pZDogZ2V0SWQoX2lkKSB9IH0gfSk7XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICBpZiAoZXJyLnN0YXR1c0NvZGUgIT09IDQwNCkge1xuICAgICAgICBsb2dnZXIuZXJyb3IoYGdldFdhdGNoOiAke2Vyci5zdGFja31gKTtcbiAgICAgIH1cbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b21FcnJvcihzZXJ2ZXJFcnJvcihlcnIpKTtcbiAgICB9XG4gIH07XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRXYXRjaFJvdXRlKHsgcm91dGVyLCBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSkge1xuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6IGAke1JPVVRFX1BBVEguV0FUQ0h9L3tpZH1gLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBpZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBnZXRXYXRjaCh7IGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KVxuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBZ0JBLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQUNBLElBQUFDLE9BQUEsR0FBQUQsT0FBQTtBQUNBLElBQUFFLFFBQUEsR0FBQUYsT0FBQTtBQUNBLElBQUFHLFVBQUEsR0FBQUgsT0FBQTtBQW5CQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBT08sU0FBU0ksUUFBUUEsQ0FBQztFQUFFQyxhQUFhO0VBQUVDO0FBQU8sQ0FBQyxFQUFFO0VBQ2xELE9BQU8sZ0JBQWdCQyxPQUFPLEVBQUVDLE9BQU8sRUFBRUMsUUFBUSxFQUFFO0lBQ2pELElBQUk7TUFDRixNQUFNO1FBQ0pDLE1BQU0sRUFBRTtVQUFFQztRQUFHLENBQUM7UUFDZEMsT0FBTyxFQUFFO1VBQUVDLFFBQVEsR0FBR0M7UUFBdUI7TUFDL0MsQ0FBQyxHQUFHTixPQUFPO01BRVgsTUFBTU8sSUFBSSxHQUFHLG1CQUFtQkMsa0JBQWtCLENBQUNILFFBQVEsQ0FBQyxJQUFJRyxrQkFBa0IsQ0FBQ0wsRUFBRSxDQUFDLEVBQUU7TUFFeEYsTUFBTTtRQUFFTSxPQUFPO1FBQUVDO01BQUksQ0FBQyxHQUNuQixNQUFNYixhQUFhLENBQUNjLFFBQVEsQ0FBQ1gsT0FBTyxDQUFDLENBQUNZLGFBQWEsQ0FBQ0MsU0FBUyxDQUFDYixPQUFPLENBQUM7UUFDdkVjLE1BQU0sRUFBRSxLQUFLO1FBQ2JQO01BQ0YsQ0FBQyxDQUFDO01BRUYsT0FBT04sUUFBUSxDQUFDYyxFQUFFLENBQUM7UUFBRUMsSUFBSSxFQUFFO1VBQUVELEVBQUUsRUFBRSxJQUFJO1VBQUVFLElBQUksRUFBRTtZQUFFLEdBQUdSLE9BQU87WUFBRUMsR0FBRyxFQUFFLElBQUFRLGNBQUssRUFBQ1IsR0FBRztVQUFFO1FBQUU7TUFBRSxDQUFDLENBQUM7SUFDbkYsQ0FBQyxDQUFDLE9BQU9TLEdBQUcsRUFBRTtNQUNaLElBQUlBLEdBQUcsQ0FBQ0MsVUFBVSxLQUFLLEdBQUcsRUFBRTtRQUMxQnRCLE1BQU0sQ0FBQ3VCLEtBQUssQ0FBQyxhQUFhRixHQUFHLENBQUNHLEtBQUssRUFBRSxDQUFDO01BQ3hDO01BQ0EsT0FBT3JCLFFBQVEsQ0FBQ3NCLFdBQVcsQ0FBQyxJQUFBQyxtQkFBVyxFQUFDTCxHQUFHLENBQUMsQ0FBQztJQUMvQztFQUNGLENBQUM7QUFDSDtBQUVPLFNBQVNNLGFBQWFBLENBQUM7RUFBRUMsTUFBTTtFQUFFN0IsYUFBYTtFQUFFQztBQUFPLENBQUMsRUFBRTtFQUMvRDRCLE1BQU0sQ0FBQ0MsR0FBRyxDQUNSO0lBQ0VwQixJQUFJLEVBQUUsR0FBR3FCLHFCQUFVLENBQUNDLEtBQUssT0FBTztJQUNoQ0MsUUFBUSxFQUFFO01BQ1I1QixNQUFNLEVBQUU2QixvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDcEI3QixFQUFFLEVBQUU0QixvQkFBTSxDQUFDRSxNQUFNLENBQUM7TUFDcEIsQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUNEckMsUUFBUSxDQUFDO0lBQUVDLGFBQWE7SUFBRUM7RUFBTyxDQUFDLENBQ3BDLENBQUM7QUFDSCIsImlnbm9yZUxpc3QiOltdfQ==