"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
exports.loginAuthHandler = loginAuthHandler;
exports.loginHandler = loginHandler;
var _configSchema = require("@kbn/config-schema");
var _authentication_error = _interopRequireDefault(require("../../errors/authentication_error"));
var _missing_tenant_error = _interopRequireDefault(require("../../errors/missing_tenant_error"));
var _missing_role_error = _interopRequireDefault(require("../../errors/missing_role_error"));
var _sanitize_next_url = require("../../sanitize_next_url");
var _routes = require("../common/routes");
var _constants = require("../../../../../utils/constants");
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2018 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

function loginHandler() {
  return async function (context, request, response) {
    return response.renderAnonymousCoreApp();
  };
}
function loginAuthHandler({
  config,
  authInstance,
  logger,
  searchGuardBackend
}) {
  return async function (context, request, response) {
    const authMethodName = 'basic';
    const username = request.body.username;
    const password = request.body.password;
    try {
      // In order to prevent direct access for certain usernames (e.g. service users like
      // kibanaserver, logstash etc.) we can add them to basicauth.forbidden_usernames.
      // If the username in the payload matches an item in the forbidden array, we throw an AuthenticationError

      const basicAuthConfig = config.get('searchguard.basicauth');
      if (basicAuthConfig.forbidden_usernames && basicAuthConfig.forbidden_usernames.length) {
        if (basicAuthConfig.forbidden_usernames.indexOf(username) > -1) {
          throw new _authentication_error.default('Invalid username or password');
        }
      }
      if (basicAuthConfig.allowed_usernames && Array.isArray(basicAuthConfig.allowed_usernames)) {
        try {
          if (basicAuthConfig.allowed_usernames.indexOf(username) === -1) {
            throw new _authentication_error.default('Invalid username or password');
          }
        } catch (error) {
          throw new _authentication_error.default('Invalid username or password');
        }
      }
      const credentials = {
        mode: authMethodName,
        user: username,
        password: password
      };
      const {
        user
      } = await authInstance.handleAuthenticate(request, credentials);

      // handle tenants if MT is enabled
      if (config.get('searchguard.multitenancy.enabled')) {
        return response.ok({
          body: {
            username: user.username,
            tenants: user.tenants,
            roles: user.roles,
            backendroles: user.backendroles,
            selectedTenant: user.selectedTenant
          }
        });
      } else {
        // no MT, nothing more to do
        return response.ok({
          body: {
            username: user.username,
            tenants: user.tenants
          }
        });
      }
    } catch (error) {
      var _error$meta, _error$meta2, _error$meta3;
      logger.error(`Basic auth login authorization ${error.stack}`);
      if ((_error$meta = error.meta) !== null && _error$meta !== void 0 && _error$meta.body && (((_error$meta2 = error.meta) === null || _error$meta2 === void 0 ? void 0 : _error$meta2.statusCode) == 401 || ((_error$meta3 = error.meta) === null || _error$meta3 === void 0 ? void 0 : _error$meta3.statusCode) === 403)) {
        return response.unauthorized({
          body: {
            attributes: error.meta.body,
            message: error.meta.body.error ? error.meta.body.error : error.message
          },
          headers: {
            'content-type': 'application/json'
          }
        });
      } else {
        return response.unauthorized({
          body: {
            message: error.message
          }
        });
      }
    }
  };
}
function defineRoutes({
  authInstance,
  kibanaCore,
  kibanaConfig,
  logger,
  searchGuardBackend
}) {
  const config = kibanaConfig;
  const basePath = kibanaCore.http.basePath.serverBasePath;
  const httpResources = kibanaCore.http.resources;
  const router = kibanaCore.http.createRouter();

  /**
   * The login page.
   */
  httpResources.register({
    path: `${_constants.APP_ROOT}/searchguard/login`,
    validate: false,
    options: {
      authRequired: false
    }
  }, loginHandler());
  router.post({
    path: `${_constants.API_ROOT}/auth/login`,
    validate: {
      body: _configSchema.schema.object({
        password: _configSchema.schema.string(),
        username: _configSchema.schema.string()
      })
    },
    options: {
      authRequired: false
    }
  }, loginAuthHandler({
    config,
    authInstance,
    logger,
    searchGuardBackend
  }));
} //end module
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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