"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchEs = void 0;
exports.searchEsRoute = searchEsRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const searchEs = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      body,
      index,
      size
    } = request.body;
    const resp = await clusterClient.asScoped(request).asCurrentUser.search({
      index,
      size,
      body
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`searchEs: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.searchEs = searchEs;
function searchEsRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.BASE_URI}/_search`,
    validate: {
      body: _configSchema.schema.object({
        body: _configSchema.schema.object({}, {
          unknowns: 'allow'
        }),
        index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]),
        size: _configSchema.schema.number({
          defaultValue: _constants.MAX_DOC_COUNT_SEARCH
        })
      }, {
        unknowns: 'allow'
      })
    }
  }, searchEs({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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