"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createWatch = createWatch;
exports.createWatchRoute = createWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function createWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        body,
        params: {
          id
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/${encodeURIComponent(id)}`;
      const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'put',
        path,
        body
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`createWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function createWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.put({
    path: `${_constants.ROUTE_PATH.WATCH}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.object({
        actions: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        })),
        checks: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        })),
        trigger: _configSchema.schema.object({}, {
          unknowns: 'allow'
        }),
        _meta: _configSchema.schema.object({}, {
          unknowns: 'allow'
        }),
        // ES plugin meta
        _ui: _configSchema.schema.object({}, {
          unknowns: 'allow'
        }),
        // UI meta
        active: _configSchema.schema.boolean(),
        log_runtime_data: _configSchema.schema.maybe(_configSchema.schema.boolean())
      }, {
        unknowns: 'allow'
      })
    }
  }, createWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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