"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WATCH_STATUS = exports.WATCH_EXAMPLES = exports.WATCH_ACTION_STATUS = exports.ROUTE_PATH = exports.PERMISSIONS_FOR_ACCESS = exports.NO_MULTITENANCY_TENANT = exports.MAX_DOC_COUNT_SEARCH = exports.INDEX = exports.ES_SCROLL_SETTINGS = exports.DEFAULT_DATEFIELD_RANGE_QUERY_LT = exports.DEFAULT_DATEFIELD_RANGE_QUERY_GTE = exports.DEFAULT_DATEFIELD = exports.BASE_URI = exports.APP_NAME = exports.APP_DESCRIPTION = void 0;
/* eslint-disable @kbn/eslint/require-license-header */
const APP_NAME = exports.APP_NAME = 'searchguard-signals';
const APP_DESCRIPTION = exports.APP_DESCRIPTION = 'Search Guard Signals';
const INDEX = exports.INDEX = {
  ALERTS: '.signals_log_*',
  ALERT_DOC_TYPE: '_doc'
};
const BASE_URI = exports.BASE_URI = `/api/${APP_NAME}`;
const ROUTE_PATH = exports.ROUTE_PATH = {
  WATCH: `${BASE_URI}/watch`,
  WATCHES: `${BASE_URI}/watches`,
  ACCOUNT: `${BASE_URI}/account`,
  ACCOUNTS: `${BASE_URI}/accounts`,
  WATCH_EXECUTE: `${BASE_URI}/watch/_execute`,
  WATCH_EXECUTE_GRAPH: `${BASE_URI}/watch/_execute_graph`,
  ALERT: `${BASE_URI}/alert`,
  ALERTS: `${BASE_URI}/alerts`,
  SEARCH: `${BASE_URI}/_search`,
  MAPPINGS: `${BASE_URI}/_mappings`,
  INDICES: `${BASE_URI}/_indices`,
  ALIASES: `${BASE_URI}/_aliases`,
  SEARCHGUARD: {
    SIGNALS_HAS_PERMISSIONS: `${BASE_URI}/searchguard/signals_has_permissions`
  }
};
const MAX_DOC_COUNT_SEARCH = exports.MAX_DOC_COUNT_SEARCH = 800;
const DEFAULT_DATEFIELD = exports.DEFAULT_DATEFIELD = 'execution_end';
const DEFAULT_DATEFIELD_RANGE_QUERY_GTE = exports.DEFAULT_DATEFIELD_RANGE_QUERY_GTE = 'now-30m';
const DEFAULT_DATEFIELD_RANGE_QUERY_LT = exports.DEFAULT_DATEFIELD_RANGE_QUERY_LT = 'now';
const ES_SCROLL_SETTINGS = exports.ES_SCROLL_SETTINGS = {
  KEEPALIVE: '25s',
  PAGE_SIZE: 10
};
const WATCH_EXAMPLES = exports.WATCH_EXAMPLES = {
  AVG_TICKET_PRICE: 'avg_ticket_price',
  BAD_WEATHER: 'bad_weather',
  CHANGE_IN_MEMORY: 'change_in_memory',
  MAX_MEMORY: 'max_memory',
  MEMORY_USAGE: 'memory_usage',
  MIN_PRODUCT_PRICE: 'min_product_price'
};
const NO_MULTITENANCY_TENANT = exports.NO_MULTITENANCY_TENANT = '_main';
const WATCH_STATUS = exports.WATCH_STATUS = {
  EXECUTION_FAILED: 'EXECUTION_FAILED',
  ACTION_FAILED: 'ACTION_FAILED',
  ACTION_EXECUTED: 'ACTION_EXECUTED',
  ACTION_THROTTLED: 'ACTION_THROTTLED',
  NO_ACTION: 'NO_ACTION',
  ACKED: 'ACKED'
};
const WATCH_ACTION_STATUS = exports.WATCH_ACTION_STATUS = {
  ACTION_FAILED: 'ACTION_FAILED',
  ACTION_THROTTLED: 'ACTION_THROTTLED',
  ACTION_EXECUTED: 'ACTION_EXECUTED',
  ACKED: 'ACKED'
};
const PERMISSIONS_FOR_ACCESS = exports.PERMISSIONS_FOR_ACCESS = ['cluster:admin:searchguard:tenant:signals:watch/get'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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