"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleKibanaConfig = handleKibanaConfig;
exports.kibanaConfigRoute = kibanaConfigRoute;
var _lodash = require("lodash");
var _constants = require("../../../utils/constants");
/* eslint-disable @kbn/eslint/require-license-header */

function handleKibanaConfig({
  config,
  logger
}) {
  return async function (context, request, response) {
    try {
      let kibanaConfig = {};

      // ATTENTION! We must be careful to not expose sensitive config to UI,
      // e.g. elasticsearch password, cookie password, TLS certificates, headers, etc.
      // That is why we explicitly serve only a portion of the config.
      if (typeof config === 'object' && config !== null) {
        kibanaConfig = {
          searchguard: (0, _lodash.pick)(config.searchguard || {}, ['enabled', 'sgVersion']),
          elasticsearch: (0, _lodash.pick)(config.elasticsearch || {}, ['username']),
          kibana: (0, _lodash.pick)(config.kibana || {}, ['index'])
        };
        config.searchguard.readonly_mode = config.searchguard.readonly_mode || {};
        kibanaConfig.searchguard.readonly_mode = (0, _lodash.pick)(config.searchguard.readonly_mode, ['roles']);
        config.searchguard.auth = config.searchguard.auth || {};
        kibanaConfig.searchguard.auth = (0, _lodash.pick)(config.searchguard.auth, ['type']);

        // At the moment we use this to decide whether to display the logout button
        kibanaConfig.uiHelpers = {};
        const resolvedContext = await context.resolve(['searchGuard']);
        if (resolvedContext.searchGuard && resolvedContext.searchGuard.authManager) {
          kibanaConfig.uiHelpers.hasAuthCookie = (await resolvedContext.searchGuard.authManager.getAuthHeader(request)) === false ? false : true;
        }
        const configService = await resolvedContext.searchGuard.configService;
        config.searchguard.multitenancy = config.searchguard.multitenancy || {};
        kibanaConfig.searchguard.multitenancy = {
          enabled: configService.get('searchguard.multitenancy.enabled'),
          ...(0, _lodash.pick)(config.searchguard.multitenancy, ['debug'])
        };
        config.searchguard.accountinfo = config.searchguard.accountinfo || {};
        kibanaConfig.searchguard.accountinfo = (0, _lodash.pick)(config.searchguard.accountinfo, ['enabled']);
      }
      logger.debug('Serve the Kibana config:', JSON.stringify(kibanaConfig, null, 2));
      return response.ok({
        body: kibanaConfig
      });
    } catch (error) {
      logger.error(error);
      return response.internalError({
        body: error
      });
    }
  };
}
function kibanaConfigRoute({
  router,
  config,
  logger
}) {
  const options = {
    path: `${_constants.API_ROOT}/${'searchguard'}/kibana_config`,
    validate: false
  };
  router.get(options, handleKibanaConfig({
    config,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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