"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAccount = void 0;
exports.deleteAccountRoute = deleteAccountRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const deleteAccount = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      id,
      type
    } = request.params;
    const path = `/_signals/account/${type}/${encodeURIComponent(id)}`;
    const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
      method: 'delete',
      path
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`deleteAccount: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.deleteAccount = deleteAccount;
function deleteAccountRoute({
  router,
  clusterClient,
  logger
}) {
  router.delete({
    path: `${_constants.ROUTE_PATH.ACCOUNT}/{type}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })
    }
  }, deleteAccount({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9lcnJvcnMiLCJfY29uc3RhbnRzIiwiZGVsZXRlQWNjb3VudCIsImNsdXN0ZXJDbGllbnQiLCJsb2dnZXIiLCJjb250ZXh0IiwicmVxdWVzdCIsInJlc3BvbnNlIiwiaWQiLCJ0eXBlIiwicGFyYW1zIiwicGF0aCIsImVuY29kZVVSSUNvbXBvbmVudCIsInJlc3AiLCJhc1Njb3BlZCIsImFzQ3VycmVudFVzZXIiLCJ0cmFuc3BvcnQiLCJtZXRob2QiLCJvayIsImJvZHkiLCJlcnIiLCJlcnJvciIsInN0YWNrIiwiY3VzdG9tRXJyb3IiLCJzZXJ2ZXJFcnJvciIsImV4cG9ydHMiLCJkZWxldGVBY2NvdW50Um91dGUiLCJyb3V0ZXIiLCJkZWxldGUiLCJST1VURV9QQVRIIiwiQUNDT1VOVCIsInZhbGlkYXRlIiwic2NoZW1hIiwib2JqZWN0Iiwic3RyaW5nIiwidW5rbm93bnMiXSwic291cmNlcyI6WyJkZWxldGUuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqICAgIENvcHlyaWdodCAyMDIwIGZsb3JhZ3VubiBHbWJIXG4gKlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTtcbiAqIHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiAqIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiAqIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuICogU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuICogbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQGtibi9jb25maWctc2NoZW1hJztcbmltcG9ydCB7IHNlcnZlckVycm9yIH0gZnJvbSAnLi4vLi4vbGliL2Vycm9ycyc7XG5pbXBvcnQgeyBST1VURV9QQVRIIH0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vY29tbW9uL3NpZ25hbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGNvbnN0IGRlbGV0ZUFjY291bnQgPSAoeyBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSkgPT4gYXN5bmMgKGNvbnRleHQsIHJlcXVlc3QsIHJlc3BvbnNlKSA9PiB7XG4gIHRyeSB7XG4gICAgY29uc3QgeyBpZCwgdHlwZSB9ID0gcmVxdWVzdC5wYXJhbXM7XG5cbiAgICBjb25zdCBwYXRoID0gYC9fc2lnbmFscy9hY2NvdW50LyR7dHlwZX0vJHtlbmNvZGVVUklDb21wb25lbnQoaWQpfWA7XG5cbiAgICBjb25zdCByZXNwID0gYXdhaXQgY2x1c3RlckNsaWVudC5hc1Njb3BlZChyZXF1ZXN0KS5hc0N1cnJlbnRVc2VyLnRyYW5zcG9ydC5yZXF1ZXN0KHtcbiAgICAgIG1ldGhvZDogJ2RlbGV0ZScsXG4gICAgICBwYXRoLFxuICAgIH0pO1xuXG4gICAgcmV0dXJuIHJlc3BvbnNlLm9rKHsgYm9keTogeyBvazogdHJ1ZSwgcmVzcCB9IH0pO1xuICB9IGNhdGNoIChlcnIpIHtcbiAgICBsb2dnZXIuZXJyb3IoYGRlbGV0ZUFjY291bnQ6ICR7ZXJyLnN0YWNrfWApO1xuICAgIHJldHVybiByZXNwb25zZS5jdXN0b21FcnJvcihzZXJ2ZXJFcnJvcihlcnIpKTtcbiAgfVxufTtcblxuZXhwb3J0IGZ1bmN0aW9uIGRlbGV0ZUFjY291bnRSb3V0ZSh7IHJvdXRlciwgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pIHtcbiAgcm91dGVyLmRlbGV0ZShcbiAgICB7XG4gICAgICBwYXRoOiBgJHtST1VURV9QQVRILkFDQ09VTlR9L3t0eXBlfS97aWR9YCxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHBhcmFtczogc2NoZW1hLm9iamVjdChcbiAgICAgICAgICB7XG4gICAgICAgICAgICBpZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgdHlwZTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgeyB1bmtub3duczogJ2FsbG93JyB9XG4gICAgICAgICksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZGVsZXRlQWNjb3VudCh7IGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KVxuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBZ0JBLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQUNBLElBQUFDLE9BQUEsR0FBQUQsT0FBQTtBQUNBLElBQUFFLFVBQUEsR0FBQUYsT0FBQTtBQWxCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBTU8sTUFBTUcsYUFBYSxHQUFHQSxDQUFDO0VBQUVDLGFBQWE7RUFBRUM7QUFBTyxDQUFDLEtBQUssT0FBT0MsT0FBTyxFQUFFQyxPQUFPLEVBQUVDLFFBQVEsS0FBSztFQUNoRyxJQUFJO0lBQ0YsTUFBTTtNQUFFQyxFQUFFO01BQUVDO0lBQUssQ0FBQyxHQUFHSCxPQUFPLENBQUNJLE1BQU07SUFFbkMsTUFBTUMsSUFBSSxHQUFHLHFCQUFxQkYsSUFBSSxJQUFJRyxrQkFBa0IsQ0FBQ0osRUFBRSxDQUFDLEVBQUU7SUFFbEUsTUFBTUssSUFBSSxHQUFHLE1BQU1WLGFBQWEsQ0FBQ1csUUFBUSxDQUFDUixPQUFPLENBQUMsQ0FBQ1MsYUFBYSxDQUFDQyxTQUFTLENBQUNWLE9BQU8sQ0FBQztNQUNqRlcsTUFBTSxFQUFFLFFBQVE7TUFDaEJOO0lBQ0YsQ0FBQyxDQUFDO0lBRUYsT0FBT0osUUFBUSxDQUFDVyxFQUFFLENBQUM7TUFBRUMsSUFBSSxFQUFFO1FBQUVELEVBQUUsRUFBRSxJQUFJO1FBQUVMO01BQUs7SUFBRSxDQUFDLENBQUM7RUFDbEQsQ0FBQyxDQUFDLE9BQU9PLEdBQUcsRUFBRTtJQUNaaEIsTUFBTSxDQUFDaUIsS0FBSyxDQUFDLGtCQUFrQkQsR0FBRyxDQUFDRSxLQUFLLEVBQUUsQ0FBQztJQUMzQyxPQUFPZixRQUFRLENBQUNnQixXQUFXLENBQUMsSUFBQUMsbUJBQVcsRUFBQ0osR0FBRyxDQUFDLENBQUM7RUFDL0M7QUFDRixDQUFDO0FBQUNLLE9BQUEsQ0FBQXZCLGFBQUEsR0FBQUEsYUFBQTtBQUVLLFNBQVN3QixrQkFBa0JBLENBQUM7RUFBRUMsTUFBTTtFQUFFeEIsYUFBYTtFQUFFQztBQUFPLENBQUMsRUFBRTtFQUNwRXVCLE1BQU0sQ0FBQ0MsTUFBTSxDQUNYO0lBQ0VqQixJQUFJLEVBQUUsR0FBR2tCLHFCQUFVLENBQUNDLE9BQU8sY0FBYztJQUN6Q0MsUUFBUSxFQUFFO01BQ1JyQixNQUFNLEVBQUVzQixvQkFBTSxDQUFDQyxNQUFNLENBQ25CO1FBQ0V6QixFQUFFLEVBQUV3QixvQkFBTSxDQUFDRSxNQUFNLENBQUMsQ0FBQztRQUNuQnpCLElBQUksRUFBRXVCLG9CQUFNLENBQUNFLE1BQU0sQ0FBQztNQUN0QixDQUFDLEVBQ0Q7UUFBRUMsUUFBUSxFQUFFO01BQVEsQ0FDdEI7SUFDRjtFQUNGLENBQUMsRUFDRGpDLGFBQWEsQ0FBQztJQUFFQyxhQUFhO0lBQUVDO0VBQU8sQ0FBQyxDQUN6QyxDQUFDO0FBQ0giLCJpZ25vcmVMaXN0IjpbXX0=