"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthTokens = void 0;
var _routes = require("./routes");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

class AuthTokens {
  constructor(coreContext) {
    this.coreContext = coreContext;
    this.logger = coreContext.logger.get('authTokens');
  }
  start({
    core,
    kibanaRouter
  }) {
    this.logger.debug('Start app');
    try {
      this.clusterClient = core.elasticsearch.client;
      (0, _routes.registerRoutes)({
        router: kibanaRouter,
        clusterClient: this.clusterClient,
        logger: this.logger
      });
    } catch (error) {
      this.logger.error(error);
    }
  }
}
exports.AuthTokens = AuthTokens;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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