"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTenantInfo = void 0;
exports.getTenantInfoRoute = getTenantInfoRoute;
var _constants = require("../../../utils/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getTenantInfo = ({
  searchGuardBackend,
  logger
}) => async (context, request, response) => {
  try {
    return response.ok({
      body: await searchGuardBackend.getUserTenantInfo(request.headers)
    });
  } catch (error) {
    logger.error(`getTenantInfo: ${error.stack}`);
    return response.internalError({
      body: error
    });
  }
};
exports.getTenantInfo = getTenantInfo;
function getTenantInfoRoute({
  router,
  searchGuardBackend,
  logger
}) {
  router.get({
    path: `${_constants.API_ROOT}/multitenancy/tenantinfo`,
    validate: false,
    options: {
      authRequired: true
    }
  }, getTenantInfo({
    searchGuardBackend,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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