"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchGuard = void 0;
var _routes = require("./routes");
var _auth = require("./auth");
var _routes2 = require("./system/routes");
var _routes3 = require("./configuration/routes/routes");
var _sanity_checks = require("./sanity_checks");
var _ReadOnlyMode = require("./authorization/ReadOnlyMode");
var _AuthManager = require("./auth/AuthManager");
var _routes_auth = require("./auth/routes_auth");
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _statehood = _interopRequireDefault(require("@hapi/statehood"));
var _CustomCookieWrapper = require("./session/CustomCookieWrapper");
/* eslint-disable @kbn/eslint/require-license-header */

class SearchGuard {
  constructor(coreContext) {
    this.coreContext = coreContext;
    this.logger = this.coreContext.logger.get('searchguard');
  }
  async setup({
    core,
    pluginDependencies,
    configService,
    kibanaRouter,
    searchGuardBackend,
    searchGuardConfigurationBackend,
    spacesService,
    elasticsearch
  }) {
    this.logger.debug('Setup app');
    try {
      // Sanity checks
      (0, _sanity_checks.checkTLSConfig)({
        configService,
        logger: this.logger
      });
      (0, _sanity_checks.checkCookieConfig)({
        configService,
        logger: this.logger
      });
      (0, _sanity_checks.checkDoNotFailOnForbidden)({
        searchGuardBackend,
        logger: this.logger
      });

      // Inits the authInfo route
      (0, _auth.defineAuthInfoRoutes)({
        searchGuardBackend,
        kibanaCore: core,
        logger: this.logger
      });
      (0, _routes.registerRoutes)({
        router: kibanaRouter,
        config: configService.getConfig(),
        logger: this.logger
      });

      // Set up our own instance of Statehood
      const cookieOptions = (0, _CustomCookieWrapper.getSessionCookieOptions)(configService, core.http.basePath.get());
      const statehoodDefinitions = new _statehood.default.Definitions(cookieOptions);
      const sessionCookieName = configService.get('searchguard.cookie.name');
      statehoodDefinitions.add(sessionCookieName, cookieOptions);
      const sessionStorageFactory = {
        asScoped(request) {
          return new _CustomCookieWrapper.CustomCookieWrapper(statehoodDefinitions, (0, _coreHttpRouterServerInternal.ensureRawRequest)(request), sessionCookieName, cookieOptions);
        }
      };
      const authType = configService.get('searchguard.auth.type', null);
      let authManager = null;
      let kerberos = null;

      // Handle Kerberos separately because we don't want to bring up entire jungle from AuthType here.
      if (authType === 'kerberos') {
        kerberos = new _auth.Kerberos({
          pluginDependencies,
          config: configService,
          searchGuardBackend,
          logger: this.coreContext.logger.get('searchguard-kerberos-auth'),
          basePath: core.http.basePath.get(),
          sessionStorageFactory: sessionStorageFactory
        });
        core.http.registerOnPreAuth(kerberos.checkAuth);
      } else if (authType !== 'proxy') {
        authManager = new _AuthManager.AuthManager({
          kibanaCore: core,
          sessionStorageFactory,
          pluginDependencies,
          logger: this.coreContext.logger.get('searchguard-auth'),
          searchGuardBackend,
          configService,
          spacesService
        });
        authManager.registerAuthInstances();
        (0, _routes_auth.defineAuthRoutes)({
          kibanaCore: core,
          authManager,
          searchGuardBackend,
          configService
        });
        if (authManager) {
          // authManager.onPreAuth needs to run before any other handler
          // that manipulates the request headers (e.g. MT)
          core.http.registerOnPreAuth(authManager.onPreAuth);
          core.http.registerOnPreAuth(authManager.checkAuth);
          core.http.registerOnPostAuth(authManager.handleAuthForOptionalRoutes);
          // @todo Not really needed anymore after taking optional auth into account.
          //core.http.registerOnPostAuth(authManager.onPostAuth);
        }
      }
      if (authType && ['proxy', 'kerberos'].indexOf(authType) === -1) {
        try {
          this.logger.info('Initialising Search Guard authentication plugin.');
          if (configService.get('searchguard.cookie.password') === 'searchguard_cookie_default_password') {
            this.logger.warn("Default cookie password detected, please set a password in kibana.yml by setting 'searchguard.cookie.password' (min. 32 characters).");
          }
          if (!configService.get('searchguard.cookie.secure')) {
            this.logger.warn("'searchguard.cookie.secure' is set to false, cookies are transmitted over unsecure HTTP connection. Consider using HTTPS and set this key to 'true'");
          }
        } catch (error) {
          this.logger.error(`An error occurred registering server plugins: ${error}`);
          throw error;
        }
      }

      // @todo TEST
      if (configService.get('searchguard.xff.enabled')) {
        require('./xff/xff')(core);
        this.logger.info('Search Guard XFF enabled.');
      }
      if (configService.get('searchguard.configuration.enabled')) {
        (0, _routes3.defineConfigurationRoutes)({
          searchGuardConfigurationBackend,
          logger: this.logger,
          kibanaCore: core
        });
        this.logger.info('Routes for Search Guard configuration GUI registered. This is an Enterprise feature.');
      } else {
        this.logger.warn('Search Guard configuration GUI disabled');
      }
      (0, _routes2.defineSystemRoutes)({
        searchGuardBackend,
        logger: this.logger,
        kibanaCore: core
      });
      this.logger.info('Search Guard system routes registered.');
      return {
        authManager,
        sessionStorageFactory,
        kerberos
      };
    } catch (error) {
      this.logger.error(error);
      throw error;
    }
  }
}
exports.SearchGuard = SearchGuard;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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