"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerWatchRoutes = registerWatchRoutes;
var _ack = require("./ack");
var _create = require("./create");
var _delete = require("./delete");
var _execute_graph = require("./execute_graph");
var _execute = require("./execute");
var _get = require("./get");
var _state = require("./state");
var _summary = require("./summary");
/* eslint-disable @kbn/eslint/require-license-header */

function registerWatchRoutes({
  router,
  clusterClient,
  logger
}) {
  (0, _ack.ackWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _ack.unAckWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _create.createWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _delete.deleteWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _execute_graph.executeGraphWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _execute.executeWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _get.getWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _state.stateOfWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _summary.summaryRoute)({
    router,
    clusterClient,
    logger
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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