"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerPlugin = void 0;
var _operators = require("rxjs/operators");
var _applications = require("./applications");
var _config_service = require("../common/config_service");
var _searchguard = _interopRequireDefault(require("./applications/searchguard/backend/searchguard"));
var _searchguard_configuration_backend = _interopRequireDefault(require("./applications/searchguard/configuration/backend/searchguard_configuration_backend"));
var _multitenancy = require("./applications/multitenancy");
var _ReadOnlyMode = require("./applications/searchguard/authorization/ReadOnlyMode");
/*
 *    Copyright 2021 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

async function getConfigService({
  kibanaIndex,
  logger,
  initContext,
  clusterClientConfig
}) {
  try {
    const [kibanaConfig, sgConfig] = await Promise.all([initContext.config.legacy.globalConfig$.pipe((0, _operators.first)()).toPromise(), initContext.config.create().pipe((0, _operators.first)()).toPromise()]);

    // We most likely don't have any kibana config here,
    // so we add the index name manually.
    let extendedKibanaConfig = {
      ...kibanaConfig,
      kibana: {
        ...kibanaConfig.kibana,
        index: kibanaIndex
      }
    };

    // This will be updated in the setup and start methods.
    // Unfortunately, calling the required endpoint and
    // awaiting the response seems to lead to some
    // kind of race condition. As a result, some
    // of the routes are never enabled.
    sgConfig.multitenancy.enabled = true;
    return new _config_service.ConfigService({
      ...extendedKibanaConfig,
      elasticsearch: clusterClientConfig,
      searchguard: sgConfig
    });
  } catch (error) {
    logger.error(`Failed to fetch the Kibana config, ${error}`);
    throw error;
  }
}
class ServerPlugin {
  constructor(initializerContext) {
    this.logger = initializerContext.logger.get();
    this.initContext = initializerContext;
    this.signalsApp = new _applications.Signals(this.initContext);
    this.searchGuardApp = new _applications.SearchGuard(this.initContext);
    this.multiTenancyApp = new _applications.Multitenancy(this.initContext);
    this.authTokensApp = new _applications.AuthTokens(this.initContext);
    this.kibanaIndex = '.kibana';
    this.readOnlyMode = null;
    this.clusterClientConfig = null;
  }

  /*
  ATTENTION! Kibana imposes restrictions to the plugin lifecycle methods:
  1. A method must not return promise.
  2. A method execution time limit is 10 seconds.
  */
  setup(core, pluginDependencies) {
    process.on('unhandledRejection', error => {
      console.error(error); // This prints error with stack included (as for normal errors)
    });
    this.kibanaRouter = core.http.createRouter();

    // Register a switcher for the read only mode
    core.capabilities.registerSwitcher(async (request, uiCapabilities) => {
      if (this.readOnlyMode) {
        return this.readOnlyMode.switcherHandler(request, uiCapabilities);
      }
      return uiCapabilities;
    }, {
      capabilityPath: '*'
    });
    (async () => {
      // With 9.2.x we lost the ability to get the config from the elasticsearch.client.
      // Instead, we fall back to this method, which is deprecated, but seems safe for now.
      // It looks like there is another more stable way in the works:
      // See: https://github.com/elastic/kibana/issues/119862
      this.clusterClientConfig = await core.elasticsearch.legacy.config$.pipe((0, _operators.first)()).toPromise();
      const [{
        elasticsearch,
        savedObjects
      }] = await core.getStartServices();
      // The core.savedObjects interface in setup() is different from in start()
      // so we need to pass an instance variable to the config service

      this.kibanaIndex = core.savedObjects.getDefaultIndex();
      const configService = await getConfigService({
        kibanaIndex: this.kibanaIndex,
        logger: this.logger,
        initContext: this.initContext,
        clusterClientConfig: this.clusterClientConfig
      });
      const searchGuardBackend = new _searchguard.default({
        elasticsearch,
        configService,
        core
      });
      const searchGuardConfigurationBackend = new _searchguard_configuration_backend.default({
        elasticsearch
      });
      if (configService.get('searchguard.readonly_mode.enabled')) {
        this.readOnlyMode = new _ReadOnlyMode.ReadOnlyMode(this.initContext.logger.get('searchguard-readonly'));
        this.readOnlyMode.setupSync({
          kibanaCoreSetup: core,
          searchGuardBackend,
          configService
        });
      }
      const tenantService = new _multitenancy.TenantService({
        clusterClient: elasticsearch.client,
        logger: this.logger,
        configService,
        savedObjects,
        coreContext: this.initContext
      });
      const spacesService = new _multitenancy.SpacesService({
        kibanaVersion: this.initContext.env.packageInfo.version,
        tenantService
      });
      const {
        authManager,
        sessionStorageFactory,
        kerberos
      } = await this.searchGuardApp.setup({
        core,
        pluginDependencies,
        configService,
        kibanaRouter: this.kibanaRouter,
        searchGuardBackend,
        searchGuardConfigurationBackend,
        spacesService,
        elasticsearch
      });

      // Helper for the routes
      core.http.registerRouteHandlerContext('searchGuard', () => {
        return {
          sessionStorageFactory,
          authManager,
          configService,
          startContext: {
            savedObjects
          }
        };
      });
      this.multiTenancyApp.setup({
        kibanaRouter: this.kibanaRouter,
        authManager,
        kerberos,
        kibanaCore: core,
        sessionStorageFactory,
        pluginDependencies,
        searchGuardBackend,
        configService,
        spacesService,
        tenantService,
        savedObjects,
        elasticsearch
      });
    })();
  }
  start(core) {
    (async () => {
      const configService = await getConfigService({
        kibanaIndex: this.kibanaIndex,
        logger: this.logger,
        initContext: this.initContext,
        clusterClientConfig: this.clusterClientConfig
      });
      const searchGuardBackend = new _searchguard.default({
        elasticsearch: core.elasticsearch,
        configService,
        core
      });
      this.signalsApp.start({
        core,
        kibanaRouter: this.kibanaRouter,
        searchguardBackendService: searchGuardBackend
      });
      this.authTokensApp.start({
        core,
        kibanaRouter: this.kibanaRouter
      });
      this.multiTenancyApp.start({
        core,
        searchGuardBackend,
        configService,
        kibanaRouter: this.kibanaRouter,
        elasticsearch: core.elasticsearch
      });
    })();
  }
}
exports.ServerPlugin = ServerPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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