/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy.test;

import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;

public class DynamicSgConfig {
    private String searchGuardIndexName = "searchguard";
    private String sgRoles = "sg_roles.yml";
    private String sgTenants = "sg_roles_tenants.yml";
    private String sgRolesMapping = "sg_roles_mapping.yml";
    private String sgInternalUsers = "sg_internal_users.yml";
    private String sgActionGroups = "sg_action_groups.yml";
    private String sgBlocks = "sg_blocks.yml";
    private String sgAuthc = "sg_authc.yml";
    private String type = "_doc";
    private String legacyConfigFolder = "";

    public String getSearchGuardIndexName() {
        return this.searchGuardIndexName;
    }

    public DynamicSgConfig setSearchGuardIndexName(String searchGuardIndexName) {
        this.searchGuardIndexName = searchGuardIndexName;
        return this;
    }

    public DynamicSgConfig setSgRoles(String sgRoles) {
        this.sgRoles = sgRoles;
        return this;
    }

    public DynamicSgConfig setSgRolesMapping(String sgRolesMapping) {
        this.sgRolesMapping = sgRolesMapping;
        return this;
    }

    public DynamicSgConfig setSgInternalUsers(String sgInternalUsers) {
        this.sgInternalUsers = sgInternalUsers;
        return this;
    }

    public DynamicSgConfig setSgActionGroups(String sgActionGroups) {
        this.sgActionGroups = sgActionGroups;
        return this;
    }

    public DynamicSgConfig setSgTenants(String sgTenants) {
        this.sgTenants = sgTenants;
        return this;
    }

    public DynamicSgConfig setSgBlocks(String sgBlocks) {
        this.sgBlocks = sgBlocks;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public List<IndexRequest> getDynamicConfig(String folder) {
        String prefix = this.legacyConfigFolder + (String)(folder == null ? "" : folder + "/");
        ArrayList<IndexRequest> ret = new ArrayList<IndexRequest>();
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).id(CType.AUTHC.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{CType.AUTHC.toLCString(), FileHelper.readYamlContent((String)(prefix + this.sgAuthc))}));
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).id(CType.ACTIONGROUPS.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{CType.ACTIONGROUPS.toLCString(), FileHelper.readYamlContent((String)(prefix + this.sgActionGroups))}));
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).id(CType.INTERNALUSERS.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{CType.INTERNALUSERS.toLCString(), FileHelper.readYamlContent((String)(prefix + this.sgInternalUsers))}));
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).id(CType.ROLES.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{CType.ROLES.toLCString(), FileHelper.readYamlContent((String)(prefix + this.sgRoles))}));
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).id(CType.ROLESMAPPING.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{CType.ROLESMAPPING.toLCString(), FileHelper.readYamlContent((String)(prefix + this.sgRolesMapping))}));
        if ("".equals(this.legacyConfigFolder)) {
            ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).id(CType.TENANTS.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{CType.TENANTS.toLCString(), FileHelper.readYamlContent((String)(prefix + this.sgTenants))}));
            ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).id(CType.BLOCKS.toLCString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{CType.BLOCKS.toLCString(), FileHelper.readYamlContent((String)(prefix + this.sgBlocks))}));
        }
        return Collections.unmodifiableList(ret);
    }
}

