/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs;

import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.NodeSettingsSupplier;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.PluginAwareNode;
import org.junit.rules.ExternalResource;

public class LocalCluster
extends ExternalResource {
    protected static final AtomicLong num = new AtomicLong();
    protected ClusterHelper clusterHelper = new ClusterHelper("lc_utest_n" + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_t" + System.nanoTime());
    protected ClusterInfo clusterInfo;
    protected final String resourceFolder;

    public LocalCluster(String resourceFolder, ClusterConfiguration clusterConfiguration) throws Exception {
        this(resourceFolder, new DynamicSgConfig(), Settings.EMPTY, clusterConfiguration);
    }

    public LocalCluster(String resourceFolder, DynamicSgConfig dynamicSgSettings, Settings nodeOverride, ClusterConfiguration clusterConfiguration) {
        this.resourceFolder = resourceFolder;
        this.setup(Settings.EMPTY, dynamicSgSettings, nodeOverride, true, clusterConfiguration);
    }

    protected void after() {
        if (this.clusterInfo != null) {
            try {
                Thread.sleep(1234L);
                this.clusterHelper.stopCluster();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RestHelper restHelper() {
        return new RestHelper(this.clusterInfo, this.getResourceFolder());
    }

    public RestHelper restHelper(String keyStore) {
        RestHelper result = this.restHelper();
        result.keystore = keyStore;
        result.sendHTTPClientCertificate = true;
        return result;
    }

    public RestHelper nonSslRestHelper() {
        return new RestHelper(this.clusterInfo, false, false, this.getResourceFolder());
    }

    public <X> X getInjectable(Class<X> clazz) {
        return (X)this.clusterHelper.node().injector().getInstance(clazz);
    }

    public PluginAwareNode node() {
        return this.clusterHelper.node();
    }

    public List<PluginAwareNode> allNodes() {
        return this.clusterHelper.allNodes();
    }

    public Client getInternalClient() {
        return this.getNodeClient();
    }

    public Client getNodeClient() {
        return this.clusterHelper.nodeClient();
    }

    public Client getPrivilegedConfigNodeClient() {
        return PrivilegedConfigClient.adapt((Client)this.getNodeClient());
    }

    private void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride, boolean initSearchGuardIndex, ClusterConfiguration clusterConfiguration) {
        try {
            this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettings(this.ccs(nodeOverride)), clusterConfiguration);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Settings ccs(Settings nodeOverride) throws Exception {
        return nodeOverride;
    }

    protected Settings.Builder minimumSearchGuardSettingsBuilder(int node, boolean sslOnly) {
        try {
            String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
            Settings.Builder builder = Settings.builder().put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)(prefix + "node-0-keystore.jks"))).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)(prefix + "truststore.jks"))).put("searchguard.ssl.transport.enforce_hostname_verification", false);
            if (!sslOnly) {
                builder.putList("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"});
                builder.put("searchguard.background_init_if_sgindex_not_exist", false);
            }
            return builder;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected NodeSettingsSupplier minimumSearchGuardSettings(final Settings other) {
        return new NodeSettingsSupplier(){

            public Settings get(int i) {
                return LocalCluster.this.minimumSearchGuardSettingsBuilder(i, false).put(other).build();
            }
        };
    }

    protected NodeSettingsSupplier minimumSearchGuardSettingsSslOnly(final Settings other) {
        return new NodeSettingsSupplier(){

            public Settings get(int i) {
                return LocalCluster.this.minimumSearchGuardSettingsBuilder(i, true).put(other).build();
            }
        };
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public static class Builder {
        private boolean sslEnabled;
        private String httpKeystoreFilepath = "node-0-keystore.jks";
        private String httpTruststoreFilepath = "truststore.jks";
        private String resourceFolder;
        private ClusterConfiguration clusterConfiguration = ClusterConfiguration.DEFAULT;
        private Settings.Builder nodeOverrideSettingsBuilder = Settings.builder();

        public Builder sslEnabled() {
            this.sslEnabled = true;
            return this;
        }

        public Builder resources(String resourceFolder) {
            this.resourceFolder = resourceFolder;
            return this;
        }

        public Builder clusterConfiguration(ClusterConfiguration clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
            return this;
        }

        public Builder singleNode() {
            this.clusterConfiguration = ClusterConfiguration.SINGLENODE;
            return this;
        }

        public Builder nodeSettings(Object ... settings) {
            for (int i = 0; i < settings.length - 1; i += 2) {
                String key = String.valueOf(settings[i]);
                Object value = settings[i + 1];
                this.nodeOverrideSettingsBuilder.put(key, String.valueOf(value));
            }
            return this;
        }

        public LocalCluster build() {
            try {
                if (this.sslEnabled) {
                    this.nodeOverrideSettingsBuilder.put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)(this.resourceFolder != null ? this.resourceFolder + "/" + this.httpKeystoreFilepath : this.httpKeystoreFilepath))).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)(this.resourceFolder != null ? this.resourceFolder + "/" + this.httpTruststoreFilepath : this.httpTruststoreFilepath)));
                }
                return new LocalCluster(this.resourceFolder, new DynamicSgConfig(), this.nodeOverrideSettingsBuilder.build(), this.clusterConfiguration);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

