/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.core;

import com.floragunn.searchsupport.jobs.core.DynamicQuartzThreadPool;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;

public class DynamicQuartzThreadPoolTest {
    @Test
    public void basicTest() {
        DynamicQuartzThreadPool threadPool = new DynamicQuartzThreadPool(null, "Test", "", 3, 5, Duration.ofSeconds(4L));
        Set completedTasks = Collections.newSetFromMap(new ConcurrentHashMap());
        threadPool.setPollingIntervalMs(50L);
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentWorkerCount());
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentBusyWorkerCount());
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentAvailableWorkerCount());
        Assert.assertTrue((boolean)threadPool.runInThread(() -> {
            DynamicQuartzThreadPoolTest.sleep(3000L);
            completedTasks.add("A");
        }));
        Assert.assertEquals((long)1L, (long)threadPool.getCurrentWorkerCount());
        Assert.assertEquals((long)1L, (long)threadPool.getCurrentBusyWorkerCount());
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentAvailableWorkerCount());
        Assert.assertTrue((boolean)threadPool.runInThread(() -> {
            DynamicQuartzThreadPoolTest.sleep(3000L);
            completedTasks.add("B");
        }));
        Assert.assertEquals((long)2L, (long)threadPool.getCurrentWorkerCount());
        Assert.assertEquals((long)2L, (long)threadPool.getCurrentBusyWorkerCount());
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentAvailableWorkerCount());
        Assert.assertTrue((boolean)threadPool.runInThread(() -> {
            DynamicQuartzThreadPoolTest.sleep(1000L);
            completedTasks.add("C");
        }));
        Assert.assertEquals((long)3L, (long)threadPool.getCurrentWorkerCount());
        Assert.assertEquals((long)3L, (long)threadPool.getCurrentBusyWorkerCount());
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentAvailableWorkerCount());
        Assert.assertFalse((boolean)threadPool.runInThread(() -> {
            DynamicQuartzThreadPoolTest.sleep(3000L);
            completedTasks.add("X");
        }));
        Assert.assertEquals((long)3L, (long)threadPool.getCurrentWorkerCount());
        Assert.assertEquals((long)3L, (long)threadPool.getCurrentBusyWorkerCount());
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentAvailableWorkerCount());
        int available = threadPool.blockForAvailableThreads();
        Assert.assertTrue((String)(available + ""), (available > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)threadPool.runInThread(() -> {
            DynamicQuartzThreadPoolTest.sleep(100L);
            completedTasks.add("D");
        }));
        DynamicQuartzThreadPoolTest.awaitAssert("Busy worker count did not reach 0: " + threadPool + "", () -> threadPool.getCurrentBusyWorkerCount() == 0, Duration.ofSeconds(10L));
        Assert.assertNotEquals((long)0L, (long)threadPool.getCurrentWorkerCount());
        Assert.assertEquals((long)threadPool.getCurrentWorkerCount(), (long)threadPool.getCurrentAvailableWorkerCount());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C", (Object)"D"), completedTasks);
        DynamicQuartzThreadPoolTest.awaitAssert("Idle threads have not been timed out: " + threadPool, () -> threadPool.getCurrentWorkerCount() == 0, Duration.ofSeconds(20L));
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentWorkerCount());
        Assert.assertEquals((long)0L, (long)threadPool.getCurrentAvailableWorkerCount());
        Assert.assertTrue((boolean)threadPool.runInThread(() -> completedTasks.add("E")));
        DynamicQuartzThreadPoolTest.awaitAssert("Task E finished", () -> completedTasks.contains("E"), Duration.ofSeconds(10L));
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void awaitAssert(String message, Supplier<Boolean> condition, Duration maxWaitingTime) {
        long timeout = System.currentTimeMillis() + maxWaitingTime.toMillis();
        while (!condition.get().booleanValue() && timeout >= System.currentTimeMillis()) {
            DynamicQuartzThreadPoolTest.sleep(50L);
        }
        if (condition.get().booleanValue()) {
            return;
        }
        Assert.fail((String)message);
    }
}

