/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.actions;

import com.floragunn.searchsupport.jobs.actions.TransportCheckForExecutingTriggerAction;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.quartz.TriggerKey;

public class CheckForExecutingTriggerResponse
extends BaseNodesResponse<TransportCheckForExecutingTriggerAction.NodeResponse> {
    public CheckForExecutingTriggerResponse(StreamInput in) throws IOException {
        super(in);
    }

    public CheckForExecutingTriggerResponse(ClusterName clusterName, List<TransportCheckForExecutingTriggerAction.NodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public List<TransportCheckForExecutingTriggerAction.NodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readCollectionAsList(TransportCheckForExecutingTriggerAction.NodeResponse::readNodeResponse);
    }

    public void writeNodesTo(StreamOutput out, List<TransportCheckForExecutingTriggerAction.NodeResponse> nodes) throws IOException {
        out.writeCollection(nodes);
    }

    public String toString() {
        return "CheckForExecutingTriggerResponse [failures=" + this.failures() + ", nodes=" + this.getNodesMap() + "]";
    }

    public Set<TriggerKey> getAllRunningTriggerKeys() {
        HashSet<TriggerKey> result = new HashSet<TriggerKey>();
        for (TransportCheckForExecutingTriggerAction.NodeResponse nodeResponse : this.getNodes()) {
            for (String triggerKeyString : nodeResponse.getExecutingTriggers()) {
                result.add(this.parseTriggerKeyString(triggerKeyString));
            }
        }
        return result;
    }

    private TriggerKey parseTriggerKeyString(String string) {
        int p = string.indexOf(46);
        if (p == -1) {
            return new TriggerKey(string, "");
        }
        return new TriggerKey(string.substring(p + 1), string.substring(0, p));
    }
}

