/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config.schedule;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchsupport.jobs.config.schedule.DefaultScheduleFactory;
import com.floragunn.searchsupport.jobs.config.schedule.ScheduleImpl;
import com.floragunn.searchsupport.jobs.config.schedule.elements.DailyTrigger;
import java.time.Duration;
import java.util.Collections;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.junit.Assert;
import org.junit.Test;
import org.quartz.CronTrigger;
import org.quartz.JobKey;
import org.quartz.SimpleTrigger;
import org.quartz.TimeOfDay;

public class DefaultScheduleFactoryTest {
    @Test
    public void daily() throws Exception {
        ScheduleImpl result = DefaultScheduleFactory.INSTANCE.create(new JobKey("job"), DocNode.of((String)"schedule.daily.at", (Object)"14:00:00"));
        Assert.assertEquals((String)result.toString(), (long)1L, (long)result.getTriggers().size());
        DailyTrigger dailyTrigger = (DailyTrigger)result.getTriggers().get(0);
        Assert.assertEquals((String)result.toString(), Collections.singletonList(TimeOfDay.hourMinuteAndSecondOfDay((int)14, (int)0, (int)0)), (Object)dailyTrigger.getAt());
        Assert.assertEquals((String)result.toString(), (long)1L, (long)dailyTrigger.getMisfireInstruction());
        Assert.assertEquals((Object)"{\"daily\":[{\"at\":\"14:00\"}]}", (Object)Strings.toString((ToXContent)result));
    }

    @Test
    public void daily_misfire() throws Exception {
        ScheduleImpl result = DefaultScheduleFactory.INSTANCE.create(new JobKey("job"), DocNode.of((String)"schedule.daily.at", (Object)"14:00:00", (String)"schedule.when_late", (Object)"skip"));
        Assert.assertEquals((String)result.toString(), (long)1L, (long)result.getTriggers().size());
        DailyTrigger dailyTrigger = (DailyTrigger)result.getTriggers().get(0);
        Assert.assertEquals((String)result.toString(), Collections.singletonList(TimeOfDay.hourMinuteAndSecondOfDay((int)14, (int)0, (int)0)), (Object)dailyTrigger.getAt());
        Assert.assertEquals((String)result.toString(), (long)2L, (long)dailyTrigger.getMisfireInstruction());
        Assert.assertEquals((Object)"{\"when_late\":\"skip\",\"daily\":[{\"at\":\"14:00\"}]}", (Object)Strings.toString((ToXContent)result));
    }

    @Test
    public void cron() throws Exception {
        ScheduleImpl result = DefaultScheduleFactory.INSTANCE.create(new JobKey("job"), DocNode.of((String)"schedule.cron", (Object)"*/10 * * * * ?"));
        Assert.assertEquals((String)result.toString(), (long)1L, (long)result.getTriggers().size());
        CronTrigger cronTrigger = (CronTrigger)result.getTriggers().get(0);
        Assert.assertEquals((String)result.toString(), (Object)"*/10 * * * * ?", (Object)cronTrigger.getCronExpression());
        Assert.assertEquals((String)result.toString(), (long)1L, (long)cronTrigger.getMisfireInstruction());
    }

    @Test
    public void cron_misfire() throws Exception {
        ScheduleImpl result = DefaultScheduleFactory.INSTANCE.create(new JobKey("job"), DocNode.of((String)"schedule.cron", (Object)"*/10 * * * * ?", (String)"schedule.when_late", (Object)"skip"));
        Assert.assertEquals((String)result.toString(), (long)1L, (long)result.getTriggers().size());
        CronTrigger cronTrigger = (CronTrigger)result.getTriggers().get(0);
        Assert.assertEquals((String)result.toString(), (Object)"*/10 * * * * ?", (Object)cronTrigger.getCronExpression());
        Assert.assertEquals((String)result.toString(), (long)2L, (long)cronTrigger.getMisfireInstruction());
    }

    @Test
    public void interval() throws Exception {
        ScheduleImpl result = DefaultScheduleFactory.INSTANCE.create(new JobKey("job"), DocNode.of((String)"schedule.interval", (Object)"10m"));
        Assert.assertEquals((String)result.toString(), (long)1L, (long)result.getTriggers().size());
        SimpleTrigger simpleTrigger = (SimpleTrigger)result.getTriggers().get(0);
        Assert.assertEquals((String)result.toString(), (long)Duration.ofMinutes(10L).toMillis(), (long)simpleTrigger.getRepeatInterval());
        Assert.assertEquals((String)result.toString(), (long)1L, (long)simpleTrigger.getMisfireInstruction());
        Assert.assertEquals((Object)"{\"interval\":[\"10m\"]}", (Object)Strings.toString((ToXContent)result));
    }

    @Test
    public void interval_misfire() throws Exception {
        ScheduleImpl result = DefaultScheduleFactory.INSTANCE.create(new JobKey("job"), DocNode.of((String)"schedule.interval", (Object)"10m", (String)"schedule.when_late", (Object)"skip"));
        Assert.assertEquals((String)result.toString(), (long)1L, (long)result.getTriggers().size());
        SimpleTrigger simpleTrigger = (SimpleTrigger)result.getTriggers().get(0);
        Assert.assertEquals((String)result.toString(), (long)Duration.ofMinutes(10L).toMillis(), (long)simpleTrigger.getRepeatInterval());
        Assert.assertEquals((String)result.toString(), (long)5L, (long)simpleTrigger.getMisfireInstruction());
        Assert.assertEquals((Object)"{\"when_late\":\"skip\",\"interval\":[\"10m\"]}", (Object)Strings.toString((ToXContent)result));
    }
}

