/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.core;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class DynamicQuartzThreadPool
implements ThreadPool {
    private static final Logger log = LogManager.getLogger(DynamicQuartzThreadPool.class);
    private final String threadPoolName;
    private final String threadNameSuffix;
    private final int maxThreadCount;
    private final int threadPriority;
    private final Duration threadKeepAlive;
    private final Deque<WorkerThread> availableWorkers;
    private final Set<WorkerThread> busyWorkers = new HashSet<WorkerThread>();
    private final Set<WorkerThread> allWorkers = new HashSet<WorkerThread>();
    private final AtomicInteger threadIdCounter = new AtomicInteger();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition workerAvailable = this.lock.newCondition();
    private boolean isShutdown = false;
    private final ThreadGroup threadGroup;
    private long pollingIntervalMs = 1000L;

    public DynamicQuartzThreadPool(ThreadGroup threadGroup, String threadPoolName, String threadNameSuffix, int maxThreadCount, int threadPriority, Duration threadKeepAlive) {
        this.threadGroup = threadGroup;
        this.threadPoolName = threadPoolName;
        this.maxThreadCount = maxThreadCount;
        this.threadPriority = threadPriority;
        this.threadKeepAlive = threadKeepAlive;
        this.threadNameSuffix = threadNameSuffix;
        this.availableWorkers = new ArrayDeque<WorkerThread>(maxThreadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        this.lock.lock();
        try {
            WorkerThread workerThread = this.availableWorkers.pollLast();
            if (workerThread != null) {
                this.busyWorkers.add(workerThread);
                if (workerThread.run(runnable)) {
                    boolean bl = true;
                    return bl;
                }
                this.busyWorkers.remove(workerThread);
            }
            if (this.allWorkers.size() < this.maxThreadCount) {
                this.createNewWorker(runnable);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int blockForAvailableThreads() {
        this.lock.lock();
        try {
            while (this.availableWorkers.isEmpty() && this.busyWorkers.size() >= this.maxThreadCount && !this.isShutdown) {
                try {
                    this.workerAvailable.await(this.pollingIntervalMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.warn("Unexpected InterruptedException", (Throwable)e);
                }
            }
            int n = this.maxThreadCount - this.busyWorkers.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPoolSize() {
        return this.maxThreadCount;
    }

    public void initialize() throws SchedulerConfigException {
    }

    public void startAllWorkersNow() {
        for (int i = 0; i < this.maxThreadCount; ++i) {
            this.createNewWorker(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean waitForJobsToComplete) {
        try {
            this.lock.lock();
            try {
                log.debug("Shutting down " + String.valueOf(this));
                this.isShutdown = true;
                for (WorkerThread availableWorkerThread : this.availableWorkers) {
                    availableWorkerThread.shutdown();
                    this.allWorkers.remove(availableWorkerThread);
                }
                this.availableWorkers.clear();
                for (WorkerThread workerThread : this.allWorkers) {
                    workerThread.shutdown();
                }
                this.workerAvailable.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            if (waitForJobsToComplete) {
                boolean interrupted = false;
                try {
                    this.lock.lock();
                    try {
                        while (this.busyWorkers.size() > 0) {
                            try {
                                log.debug("Waiting for threads " + String.valueOf(this.busyWorkers) + " to shut down");
                                this.workerAvailable.await(1L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                    log.debug("All busy workers finished. Waiting for worker threads to terminate: " + String.valueOf(this.allWorkers));
                    for (WorkerThread workerThread : this.allWorkers) {
                        try {
                            workerThread.join(5000L);
                            if (!workerThread.isAlive()) continue;
                            Exception stackTraceHolder = new Exception();
                            stackTraceHolder.setStackTrace(workerThread.getStackTrace());
                            log.warn("Worker thread did not properly terminate: " + String.valueOf(workerThread), (Throwable)stackTraceHolder);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                log.debug("No executing jobs remaining, all threads stopped.");
            }
            this.lock.lock();
            try {
                this.allWorkers.clear();
            }
            finally {
                this.lock.unlock();
            }
            log.debug("Shutdown of threadpool complete.");
        }
        catch (Exception e) {
            log.error("Encountered error while shutting down", (Throwable)e);
        }
    }

    public synchronized int getCurrentWorkerCount() {
        return this.allWorkers.size();
    }

    public synchronized int getCurrentAvailableWorkerCount() {
        return this.availableWorkers.size();
    }

    public synchronized int getCurrentBusyWorkerCount() {
        return this.busyWorkers.size();
    }

    public void setInstanceId(String schedulerInstanceId) {
    }

    public void setInstanceName(String schedulerInstanceName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkerThread createNewWorker(Runnable runnable) {
        WorkerThread result = new WorkerThread(this.threadGroup, this.threadPoolName + "/worker_" + this.threadIdCounter.incrementAndGet() + this.threadNameSuffix, this.threadPriority, true, runnable);
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Creating new worker: " + String.valueOf(result));
            }
            result.start();
            this.allWorkers.add(result);
            if (runnable != null) {
                this.busyWorkers.add(result);
            } else {
                this.availableWorkers.add(result);
            }
            WorkerThread workerThread = result;
            return workerThread;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void makeAvailable(WorkerThread workerThread) {
        if (log.isDebugEnabled()) {
            log.debug("makeAvailable: " + String.valueOf(workerThread));
        }
        this.lock.lock();
        try {
            if (!this.isShutdown) {
                this.availableWorkers.add(workerThread);
            }
            this.busyWorkers.remove(workerThread);
            this.workerAvailable.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void onTermination(WorkerThread workerThread) {
        if (log.isDebugEnabled()) {
            log.debug("onTermination: " + String.valueOf(workerThread));
        }
        this.lock.lock();
        try {
            this.allWorkers.remove(workerThread);
            this.busyWorkers.remove(workerThread);
            this.availableWorkers.remove(workerThread);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "DynamicQuartzThreadPool [threadPoolName=" + this.threadPoolName + ", maxThreadCount=" + this.maxThreadCount + ", threadPriority=" + this.threadPriority + ", threadKeepAlive=" + String.valueOf(this.threadKeepAlive) + "]";
    }

    public long getPollingIntervalMs() {
        return this.pollingIntervalMs;
    }

    public void setPollingIntervalMs(long pollingIntervalMs) {
        this.pollingIntervalMs = pollingIntervalMs;
    }

    class WorkerThread
    extends Thread {
        private boolean running;
        private Runnable runnable;
        private Instant idleSince;

        WorkerThread(ThreadGroup threadGroup, String name, int prio, boolean isDaemon, Runnable runnable) {
            super(threadGroup, name);
            this.running = true;
            this.runnable = null;
            this.idleSince = Instant.now();
            this.runnable = runnable;
            this.setPriority(prio);
            this.setDaemon(isDaemon);
        }

        synchronized void shutdown() {
            this.running = false;
            this.notifyAll();
        }

        public synchronized boolean run(Runnable newRunnable) {
            if (!this.running) {
                return false;
            }
            if (this.runnable != null) {
                throw new IllegalStateException("Already running a Runnable!");
            }
            this.runnable = newRunnable;
            this.notifyAll();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    Runnable doRun = null;
                    WorkerThread workerThread = this;
                    synchronized (workerThread) {
                        if (this.runnable == null) {
                            if (this.idleSince.plus(DynamicQuartzThreadPool.this.threadKeepAlive).isBefore(Instant.now())) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Retiring " + String.valueOf(this) + " due to inactivity. Last activity: " + String.valueOf(this.idleSince) + "; keep alive: " + String.valueOf(DynamicQuartzThreadPool.this.threadKeepAlive));
                                }
                                this.running = false;
                                break;
                            }
                            this.wait(DynamicQuartzThreadPool.this.pollingIntervalMs);
                            if (!this.running) {
                                break;
                            }
                            continue;
                        }
                        doRun = this.runnable;
                    }
                    if (doRun == null) continue;
                    try {
                        this.runnable.run();
                    }
                    catch (Throwable e) {
                        log.error("Error while executing the Runnable: ", e);
                    }
                    finally {
                        workerThread = this;
                        synchronized (workerThread) {
                            this.runnable = null;
                            this.idleSince = Instant.now();
                        }
                        DynamicQuartzThreadPool.this.makeAvailable(this);
                    }
                }
                catch (InterruptedException unblock) {
                    log.warn("Worker thread was interrupt()'ed.", (Throwable)unblock);
                }
                catch (Exception e) {
                    log.error("Unexpected exception in " + String.valueOf(this), (Throwable)e);
                }
            }
            DynamicQuartzThreadPool.this.onTermination(this);
            try {
                log.debug("WorkerThread is shut down.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

