/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchsupport.jobs.config.JobConfig;
import com.floragunn.searchsupport.jobs.config.JobConfigFactory;
import com.floragunn.searchsupport.jobs.config.schedule.DefaultScheduleFactory;
import com.floragunn.searchsupport.jobs.config.schedule.ScheduleFactory;
import com.jayway.jsonpath.TypeRef;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Trigger;

public abstract class AbstractJobConfigFactory<JobConfigType extends JobConfig>
implements JobConfigFactory<JobConfigType> {
    protected String group = "main";
    protected Class<? extends Job> jobClass;
    protected ScheduleFactory<?> triggerFactory;
    protected static final TypeRef<Map<String, Object>> MAP_TYPE_REF = new TypeRef<Map<String, Object>>(){};

    public AbstractJobConfigFactory(Class<? extends Job> jobClass, ScheduleFactory<?> triggerFactory) {
        this.jobClass = jobClass;
        this.triggerFactory = triggerFactory != null ? triggerFactory : new DefaultScheduleFactory();
    }

    public AbstractJobConfigFactory(Class<? extends Job> jobClass) {
        this(jobClass, null);
    }

    @Override
    public JobConfigType createFromBytes(String id, BytesReference source, long version) throws ConfigValidationException {
        DocNode jsonNode = DocNode.parse((Format)Format.JSON).from(source.utf8ToString());
        return this.createFromJsonNode(id, jsonNode, version);
    }

    @Override
    public JobDetail createJobDetail(JobConfigType jobType) {
        JobBuilder jobBuilder = JobBuilder.newJob(jobType.getJobClass());
        jobBuilder.withIdentity(jobType.getJobKey());
        if (jobType.getJobDataMap() != null) {
            jobBuilder.setJobData(new JobDataMap(jobType.getJobDataMap()));
        }
        jobBuilder.withDescription(jobType.getDescription());
        jobBuilder.storeDurably(jobType.isDurable());
        return jobBuilder.build();
    }

    protected abstract JobConfigType createFromJsonNode(String var1, DocNode var2, long var3) throws ConfigValidationException;

    protected JobKey getJobKey(String id, DocNode jsonNode) {
        return new JobKey(id, this.group);
    }

    protected String getDescription(DocNode jsonNode) {
        if (jsonNode.hasNonNull("description")) {
            return jsonNode.getAsString("description");
        }
        return null;
    }

    protected Map<String, Object> getJobDataMap(DocNode jsonNode) {
        return Collections.emptyMap();
    }

    protected Boolean getDurability(DocNode jsonNode) {
        return Boolean.TRUE;
    }

    protected List<Trigger> getTriggers(JobKey jobKey, DocNode jsonNode) throws ConfigValidationException {
        DocNode triggerNode = jsonNode.getAsNode("trigger");
        if (triggerNode != null && triggerNode.isMap()) {
            try {
                return this.triggerFactory.create(jobKey, triggerNode).getTriggers();
            }
            catch (ConfigValidationException e) {
                ValidationErrors validationErrors = new ValidationErrors();
                validationErrors.add("trigger", e);
                validationErrors.throwExceptionForPresentErrors();
            }
        }
        return Collections.emptyList();
    }

    protected String getAuthToken(DocNode jsonNode) {
        DocNode authTokenNode = jsonNode.getAsNode("meta.auth_token");
        if (authTokenNode != null) {
            return authTokenNode.toString();
        }
        return null;
    }

    protected Class<? extends Job> getJobClass(DocNode jsonNode) {
        return this.jobClass;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Class<? extends Job> getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(Class<? extends Job> jobClass) {
        this.jobClass = jobClass;
    }
}

