/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.util.duration;

import com.floragunn.codova.config.temporal.DurationFormat;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class DurationFormatTest {
    @Test
    public void parseTest1() throws Exception {
        Duration duration1 = DurationFormat.INSTANCE.parse("3d 2h 1m");
        Duration duration2 = Duration.parse("P3DT2H1M");
        Assert.assertEquals((Object)duration2, (Object)duration1);
    }

    @Test
    public void parseTest2() throws Exception {
        Duration duration1 = DurationFormat.INSTANCE.parse("20m");
        Duration duration2 = Duration.parse("PT20M");
        Assert.assertEquals((Object)duration2, (Object)duration1);
    }

    @Test
    public void parseTest3() throws Exception {
        Duration duration1 = DurationFormat.INSTANCE.parse("3d2h1m");
        Duration duration2 = Duration.parse("P3DT2H1M");
        Assert.assertEquals((Object)duration2, (Object)duration1);
    }

    @Test
    public void parseZeroTest() throws Exception {
        Duration duration1 = DurationFormat.INSTANCE.parse("0");
        Assert.assertEquals((long)0L, (long)duration1.getSeconds());
        Assert.assertEquals((long)0L, (long)duration1.getNano());
    }

    @Test
    public void formatTest1() throws Exception {
        String s = "5w4d3h2m1s";
        Duration duration = DurationFormat.INSTANCE.parse(s);
        Assert.assertEquals((Object)s, (Object)DurationFormat.INSTANCE.format(duration));
    }

    @Test
    public void formatTest2() throws Exception {
        String s = "2m59s";
        Duration duration = DurationFormat.INSTANCE.parse(s);
        Assert.assertEquals((Object)s, (Object)DurationFormat.INSTANCE.format(duration));
    }

    @Test
    public void formatZeroTest() throws Exception {
        String s = "0";
        Duration duration = DurationFormat.INSTANCE.parse(s);
        Assert.assertEquals((Object)s, (Object)DurationFormat.INSTANCE.format(duration));
    }
}

