/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.util.duration;

import com.floragunn.codova.config.temporal.DurationExpression;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class DurationExpressionTest {
    @Test
    public void constantTest() throws Exception {
        DurationExpression durationExpression = DurationExpression.parse((String)"3h 2m");
        Duration duration = Duration.parse("PT3H2M");
        Assert.assertEquals((Object)duration, (Object)durationExpression.getActualDuration(0));
        Assert.assertEquals((Object)duration, (Object)durationExpression.getActualDuration(1));
        Assert.assertEquals((Object)duration, (Object)durationExpression.getActualDuration(2));
        Assert.assertEquals((Object)duration, (Object)durationExpression.getActualDuration(3));
    }

    @Test
    public void exponentialTest() throws Exception {
        DurationExpression durationExpression = DurationExpression.parse((String)"1h**2");
        Assert.assertEquals((Object)Duration.parse("PT1H"), (Object)durationExpression.getActualDuration(0));
        Assert.assertEquals((Object)Duration.parse("PT2H"), (Object)durationExpression.getActualDuration(1));
        Assert.assertEquals((Object)Duration.parse("PT4H"), (Object)durationExpression.getActualDuration(2));
        Assert.assertEquals((Object)Duration.parse("PT8H"), (Object)durationExpression.getActualDuration(3));
        Assert.assertEquals((Object)Duration.parse("PT16H"), (Object)durationExpression.getActualDuration(4));
        Assert.assertEquals((Object)Duration.parse("PT24H"), (Object)durationExpression.getActualDuration(5));
        Assert.assertEquals((Object)Duration.parse("PT24H"), (Object)durationExpression.getActualDuration(6));
    }

    @Test
    public void exponentialCappedTest() throws Exception {
        DurationExpression durationExpression = DurationExpression.parse((String)"1m**2|1h");
        Assert.assertEquals((Object)Duration.parse("PT1M"), (Object)durationExpression.getActualDuration(0));
        Assert.assertEquals((Object)Duration.parse("PT2M"), (Object)durationExpression.getActualDuration(1));
        Assert.assertEquals((Object)Duration.parse("PT4M"), (Object)durationExpression.getActualDuration(2));
        Assert.assertEquals((Object)Duration.parse("PT8M"), (Object)durationExpression.getActualDuration(3));
        Assert.assertEquals((Object)Duration.parse("PT16M"), (Object)durationExpression.getActualDuration(4));
        Assert.assertEquals((Object)Duration.parse("PT32M"), (Object)durationExpression.getActualDuration(5));
        Assert.assertEquals((Object)Duration.parse("PT60M"), (Object)durationExpression.getActualDuration(6));
        Assert.assertEquals((Object)Duration.parse("PT60M"), (Object)durationExpression.getActualDuration(7));
    }
}

