/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy.auth;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;

public class HTTPBasicAuthenticator
implements LegacyHTTPAuthenticator,
ApiAuthenticationFrontend {
    protected static final Logger log = LogManager.getLogger(HTTPBasicAuthenticator.class);
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "basic", HTTPBasicAuthenticator.class).initialized();
    public static TypedComponent.Info<LegacyHTTPAuthenticator> INFO = new TypedComponent.Info<LegacyHTTPAuthenticator>(){

        public Class<LegacyHTTPAuthenticator> getType() {
            return LegacyHTTPAuthenticator.class;
        }

        public String getName() {
            return "basic";
        }

        public TypedComponent.Factory<LegacyHTTPAuthenticator> getFactory() {
            return LegacyComponentFactory.adapt(HTTPBasicAuthenticator::new);
        }
    };

    public HTTPBasicAuthenticator(Settings settings, Path configPath) {
    }

    public AuthCredentials extractCredentials(RestRequest request, ThreadContext threadContext) {
        boolean forceLogin = request.paramAsBoolean("force_login", false);
        if (forceLogin) {
            return null;
        }
        String authorizationHeader = request.header("Authorization");
        AuthCredentials.Builder credsBuilder = HTTPBasicAuthenticator.extractCredentials(authorizationHeader);
        if (credsBuilder != null) {
            return credsBuilder.authenticatorType(this.getType()).build();
        }
        return null;
    }

    public String getType() {
        return "basic";
    }

    public String getChallenge(AuthCredentials credentials) {
        return "Basic realm=\"Search Guard\"";
    }

    public AuthCredentials extractCredentials(Map<String, Object> request) throws CredentialsException, ConfigValidationException, AuthenticatorUnavailableException {
        ValidationErrors validationErrors = new ValidationErrors();
        if (request.get("user") == null) {
            validationErrors.add((ValidationError)new MissingAttribute("user", null));
        }
        if (request.get("password") == null) {
            validationErrors.add((ValidationError)new MissingAttribute("password", null));
        }
        validationErrors.throwExceptionForPresentErrors();
        return AuthCredentials.forUser((String)String.valueOf(request.get("user"))).password(String.valueOf(request.get("password")).getBytes(StandardCharsets.UTF_8)).complete().build();
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private static AuthCredentials.Builder extractCredentials(String authorizationHeader) {
        if (authorizationHeader != null) {
            if (!authorizationHeader.trim().toLowerCase().startsWith("basic ")) {
                log.debug("No 'Basic Authorization' header, send 401 and 'WWW-Authenticate Basic'");
                return null;
            }
            String decodedBasicHeader = new String(Base64.getDecoder().decode(authorizationHeader.split(" ")[1]), StandardCharsets.UTF_8);
            int firstColonIndex = decodedBasicHeader.indexOf(58);
            String username = null;
            String password = null;
            if (firstColonIndex > 0) {
                username = decodedBasicHeader.substring(0, firstColonIndex);
                password = decodedBasicHeader.length() - 1 != firstColonIndex ? decodedBasicHeader.substring(firstColonIndex + 1) : "";
            }
            if (username == null || password == null) {
                log.debug("Invalid 'Authorization' header, send 401 and 'WWW-Authenticate Basic'");
                return null;
            }
            return AuthCredentials.forUser((String)username).password(password.getBytes(StandardCharsets.UTF_8)).complete();
        }
        return null;
    }
}

